/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.util.Set;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.util.RoutingNetworkLink;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.utils.objectattributes.attributable.Attributes;

public abstract class AbstractRoutingNetworkLink
implements RoutingNetworkLink {
    private final Link link;
    private final RoutingNetworkNode toNode;
    private final RoutingNetworkNode fromNode;

    AbstractRoutingNetworkLink(Link link, RoutingNetworkNode fromNode, RoutingNetworkNode toNode) {
        this.link = link;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    @Override
    public double getFlowCapacityPerSec() {
        return this.link.getFlowCapacityPerSec();
    }

    @Override
    public double getFlowCapacityPerSec(double time) {
        return this.link.getFlowCapacityPerSec(time);
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    @Override
    public Id<Link> getId() {
        return this.link.getId();
    }

    @Override
    public RoutingNetworkNode getFromNode() {
        return this.fromNode;
    }

    @Override
    public RoutingNetworkNode getToNode() {
        return this.toNode;
    }

    @Override
    public Set<String> getAllowedModes() {
        return this.link.getAllowedModes();
    }

    @Override
    public double getCapacity() {
        return this.link.getCapacity();
    }

    @Override
    public double getCapacity(double time) {
        return this.link.getCapacity(time);
    }

    @Override
    public double getFreespeed() {
        return this.link.getFreespeed();
    }

    @Override
    public double getFreespeed(double time) {
        return this.link.getFreespeed(time);
    }

    @Override
    public double getLength() {
        return this.link.getLength();
    }

    @Override
    public double getNumberOfLanes() {
        return this.link.getNumberOfLanes();
    }

    @Override
    public double getNumberOfLanes(double time) {
        return this.link.getNumberOfLanes(time);
    }

    @Override
    public void setAllowedModes(Set<String> modes) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void setCapacity(double capacity) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void setFreespeed(double freespeed) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public boolean setFromNode(Node node) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void setLength(double length) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void setNumberOfLanes(double lanes) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public boolean setToNode(Node node) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Coord getCoord() {
        return this.link.getCoord();
    }

    @Override
    public Attributes getAttributes() {
        return this.link.getAttributes();
    }
}

