/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.RoutingNetworkLink;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.utils.objectattributes.attributable.Attributes;

public abstract class AbstractRoutingNetworkNode
implements RoutingNetworkNode {
    private final Node node;
    private final RoutingNetworkLink[] outLinks;
    private PreProcessDijkstra.DeadEndData deadEndData;

    AbstractRoutingNetworkNode(Node node, int numOutLinks) {
        this.node = node;
        this.outLinks = new RoutingNetworkLink[numOutLinks];
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void setOutLinksArray(RoutingNetworkLink[] outLinks) {
        System.arraycopy(outLinks, 0, this.outLinks, 0, outLinks.length);
    }

    @Override
    public RoutingNetworkLink[] getOutLinksArray() {
        return this.outLinks;
    }

    @Override
    public void setDeadEndData(PreProcessDijkstra.DeadEndData deadEndData) {
        this.deadEndData = deadEndData;
    }

    @Override
    public PreProcessDijkstra.DeadEndData getDeadEndData() {
        return this.deadEndData;
    }

    @Override
    public Id<Node> getId() {
        return this.node.getId();
    }

    @Override
    public Coord getCoord() {
        return this.node.getCoord();
    }

    @Override
    public boolean addInLink(Link link) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public boolean addOutLink(Link link) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Map<Id<Link>, ? extends Link> getInLinks() {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Map<Id<Link>, ? extends Link> getOutLinks() {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Attributes getAttributes() {
        return this.node.getAttributes();
    }
}

