/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.LinkFactory;
import org.matsim.core.router.util.AbstractRoutingNetworkFactory;
import org.matsim.core.router.util.ArrayRoutingNetwork;
import org.matsim.core.router.util.ArrayRoutingNetworkLink;
import org.matsim.core.router.util.ArrayRoutingNetworkNode;
import org.matsim.core.router.util.RoutingNetworkLink;
import org.matsim.core.router.util.RoutingNetworkNode;

public class ArrayRoutingNetworkFactory
extends AbstractRoutingNetworkFactory {
    private static final Logger log = Logger.getLogger(ArrayRoutingNetworkFactory.class);
    private int nodeArrayIndexCounter;
    private int linkArrayIndexCounter;

    @Override
    public synchronized ArrayRoutingNetwork createRoutingNetwork(Network network) {
        this.nodeArrayIndexCounter = 0;
        this.linkArrayIndexCounter = 0;
        ArrayRoutingNetwork routingNetwork = new ArrayRoutingNetwork(network);
        for (Node node : network.getNodes().values()) {
            ArrayRoutingNetworkNode arrayRoutingNetworkNode = this.createRoutingNetworkNode(node, node.getOutLinks().size());
            routingNetwork.addNode(arrayRoutingNetworkNode);
        }
        HashMap<Id<Link>, Object> routingLinks = new HashMap<Id<Link>, Object>();
        for (Link link : network.getLinks().values()) {
            RoutingNetworkNode fromNode = routingNetwork.getNodes().get(link.getFromNode().getId());
            RoutingNetworkNode toNode = routingNetwork.getNodes().get(link.getToNode().getId());
            ArrayRoutingNetworkLink dijkstraLink = this.createRoutingNetworkLink(link, fromNode, toNode);
            routingLinks.put(dijkstraLink.getId(), dijkstraLink);
        }
        for (Node node : network.getNodes().values()) {
            RoutingNetworkLink[] outLinks = new RoutingNetworkLink[node.getOutLinks().size()];
            int i = 0;
            for (Link link : node.getOutLinks().values()) {
                outLinks[i] = (RoutingNetworkLink)routingLinks.remove(link.getId());
                ++i;
            }
            RoutingNetworkNode dijkstraNode = routingNetwork.getNodes().get(node.getId());
            dijkstraNode.setOutLinksArray(outLinks);
        }
        if (routingLinks.size() > 0) {
            log.warn("Not all links have been use in the ArrayRoutingNetwork - check connectivity of input network!");
        }
        return routingNetwork;
    }

    @Override
    public ArrayRoutingNetworkNode createRoutingNetworkNode(Node node, int numOutLinks) {
        return new ArrayRoutingNetworkNode(node, numOutLinks, this.nodeArrayIndexCounter++);
    }

    @Override
    public ArrayRoutingNetworkLink createRoutingNetworkLink(Link link, RoutingNetworkNode fromNode, RoutingNetworkNode toNode) {
        return new ArrayRoutingNetworkLink(link, fromNode, toNode, this.linkArrayIndexCounter++);
    }

    @Override
    public void setLinkFactory(LinkFactory factory) {
        throw new RuntimeException("not implemented");
    }
}

