/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.CoordUtils;

class LandmarkerPieSlices {
    private Node[] landmarks;
    private Coord center = null;
    private final Rectangle2D.Double travelZone;
    private static final Logger log = Logger.getLogger(LandmarkerPieSlices.class);
    private static final double ZONE_EXPANSION = 0.1;

    LandmarkerPieSlices(int landmarkCount, Rectangle2D.Double travelZone) {
        this.landmarks = new Node[landmarkCount];
        this.travelZone = travelZone;
    }

    public void run(Network network) {
        Collection<? extends Node> nodes = this.travelZone.getHeight() == 0.0 || this.travelZone.getWidth() == 0.0 ? network.getNodes().values() : this.getNodesInTravelZone(network);
        this.run(nodes);
    }

    private Set<Node> getNodesInTravelZone(Network network) {
        double minX = this.travelZone.getX();
        double maxX = this.travelZone.getWidth() + minX;
        double minY = this.travelZone.getY();
        double maxY = this.travelZone.getHeight() + minY;
        maxX += (maxX - minX) * 0.1;
        minX -= (maxX - minX) * 0.1;
        maxY += (maxY - minY) * 0.1;
        minY -= (maxY - minY) * 0.1;
        TreeSet<Node> resultNodes = new TreeSet<Node>();
        for (Node node : network.getNodes().values()) {
            if (!(node.getCoord().getX() <= maxX) || !(node.getCoord().getX() >= minX) || !(node.getCoord().getY() <= maxY) || !(node.getCoord().getY() >= minY)) continue;
            resultNodes.add(node);
        }
        return resultNodes;
    }

    public void run(Collection<? extends Node> nodes) {
        this.center = this.getCenter(nodes);
        this.putLandmarks(nodes, this.landmarks.length);
    }

    private void putLandmarks(Collection<? extends Node> nodes, int landmarkCount) {
        ArrayList<ArrayList<Node>> sectors = new ArrayList<ArrayList<Node>>();
        log.info("Filling sectors...");
        double[][] angles = this.fillSectors(sectors, nodes);
        if (angles.length < landmarkCount) {
            log.info("Reducing number of landmarks from " + landmarkCount + " to " + angles.length + "...");
            this.landmarks = new Node[angles.length];
        }
        for (int i = 0; i < this.landmarks.length; ++i) {
            this.landmarks[i] = this.getLandmark(sectors.get(i), angles[i]);
        }
        log.info("Refining landmarks...");
        this.refineLandmarks(sectors, angles);
        log.info("done");
    }

    private double[][] fillSectors(ArrayList<ArrayList<Node>> sectors, Collection<? extends Node> nodes) {
        ArrayList<double[]> angles = new ArrayList<double[]>();
        TreeMap<Double, Node[]> sortedNodes = new TreeMap<Double, Node[]>();
        for (Node node : nodes) {
            double x = node.getCoord().getX() - this.center.getX();
            double y = node.getCoord().getY() - this.center.getY();
            double angle = Math.atan2(y, x) + Math.PI;
            Node[] nodeList = (Node[])sortedNodes.get(angle);
            if (nodeList == null) {
                nodeList = new Node[]{node};
            } else {
                Node[] nodeList2 = new Node[nodeList.length + 1];
                System.arraycopy(nodeList, 0, nodeList2, 0, nodeList.length);
                nodeList2[nodeList.length] = node;
                nodeList = nodeList2;
            }
            sortedNodes.put(angle, nodeList);
        }
        double lastAngle = 0.0;
        Iterator it = sortedNodes.values().iterator();
        if (it.hasNext()) {
            Node[] tmpNodes = (Node[])it.next();
            int k = 0;
            for (int i = 0; i < this.landmarks.length; ++i) {
                sectors.add(new ArrayList());
                Node node = null;
                for (int j = 0; j < nodes.size() / this.landmarks.length; ++j) {
                    if (k == tmpNodes.length) {
                        tmpNodes = (Node[])it.next();
                        k = 0;
                    }
                    node = tmpNodes[k++];
                    sectors.get(angles.size()).add(node);
                }
                if (i == this.landmarks.length - 1) {
                    while (it.hasNext() || k < tmpNodes.length) {
                        if (k == tmpNodes.length) {
                            tmpNodes = (Node[])it.next();
                            k = 0;
                        }
                        node = tmpNodes[k++];
                        sectors.get(angles.size()).add(node);
                    }
                }
                if (sectors.get(angles.size()).isEmpty()) {
                    log.info("There is no node in sector " + i + "!");
                    sectors.remove(angles.size());
                    continue;
                }
                double x = node.getCoord().getX() - this.center.getX();
                double y = node.getCoord().getY() - this.center.getY();
                double angle = Math.atan2(y, x) + Math.PI;
                double[] tmp = new double[]{lastAngle, angle};
                angles.add(tmp);
                lastAngle = angle;
            }
        }
        return (double[][])angles.toArray((T[])new double[0][2]);
    }

    private Node getLandmark(ArrayList<Node> nodes, double[] angles) {
        double maxDist = Double.NEGATIVE_INFINITY;
        Node landmark = null;
        for (Node node : nodes) {
            if ((node.getOutLinks().size() <= 1 || node.getInLinks().size() <= 1) && landmark != null) continue;
            double x = node.getCoord().getX() - this.center.getX();
            double y = node.getCoord().getY() - this.center.getY();
            double angle = Math.atan2(y, x) + Math.PI;
            double minAngelToBorder = 0.0;
            minAngelToBorder = angle - angles[0] < angles[1] - angle ? angle - angles[0] : angles[1] - angle;
            double distApprox = Math.sqrt(x * x + y * y) * (1.0 + minAngelToBorder / (Math.PI * 2));
            if (!(distApprox > maxDist)) continue;
            landmark = node;
            maxDist = distApprox;
        }
        return landmark;
    }

    private void refineLandmarks(ArrayList<ArrayList<Node>> sectors, double[][] sectorAngles) {
        boolean doRefine = true;
        double[] landmarkAngels = new double[this.landmarks.length];
        for (int i = 0; i < this.landmarks.length; ++i) {
            double x = this.landmarks[i].getCoord().getX() - this.center.getX();
            double y = this.landmarks[i].getCoord().getY() - this.center.getY();
            landmarkAngels[i] = Math.atan2(y, x) + Math.PI;
        }
        double minAngelFactor = 0.5;
        block1: while (doRefine) {
            doRefine = false;
            for (int i = 0; i < this.landmarks.length && !sectors.get(i).isEmpty(); ++i) {
                double angelDiff;
                int preInd = i - 1;
                if (preInd == -1) {
                    preInd = this.landmarks.length - 1;
                    angelDiff = Math.PI * 2 + landmarkAngels[i] - landmarkAngels[preInd];
                } else {
                    angelDiff = landmarkAngels[i] - landmarkAngels[preInd];
                }
                double minSectorSize = sectorAngles[i][1] - sectorAngles[i][0];
                if (sectorAngles[preInd][1] - sectorAngles[preInd][0] < minSectorSize) {
                    minSectorSize = sectorAngles[preInd][1] - sectorAngles[preInd][0];
                }
                if (!(angelDiff < minSectorSize * minAngelFactor)) continue;
                int indexToChange = 0;
                if (CoordUtils.calcEuclideanDistance(this.center, this.landmarks[preInd].getCoord()) < CoordUtils.calcEuclideanDistance(this.center, this.landmarks[i].getCoord())) {
                    double[] dArray = sectorAngles[preInd];
                    dArray[1] = dArray[1] - minSectorSize * minAngelFactor;
                    indexToChange = preInd;
                } else {
                    double[] dArray = sectorAngles[i];
                    dArray[0] = dArray[0] + minSectorSize * minAngelFactor;
                    indexToChange = i;
                }
                this.removeNodesFromSector(sectors.get(indexToChange), sectorAngles[indexToChange]);
                if (sectors.get(indexToChange).isEmpty()) {
                    log.info("There is no node in sector " + indexToChange + " after narrowing it!");
                } else {
                    this.landmarks[indexToChange] = this.getLandmark(sectors.get(indexToChange), sectorAngles[indexToChange]);
                }
                double x = this.landmarks[indexToChange].getCoord().getX() - this.center.getX();
                double y = this.landmarks[indexToChange].getCoord().getY() - this.center.getY();
                landmarkAngels[indexToChange] = Math.atan2(y, x) + Math.PI;
                doRefine = true;
                continue block1;
            }
        }
    }

    private void removeNodesFromSector(ArrayList<Node> sector, double[] sectorAngles) {
        int i = 0;
        while (i < sector.size()) {
            Node node = sector.get(i);
            double x = node.getCoord().getX() - this.center.getX();
            double y = node.getCoord().getY() - this.center.getY();
            double angle = Math.atan2(y, x) + Math.PI;
            if (angle < sectorAngles[0] || angle > sectorAngles[1]) {
                sector.remove(i);
                continue;
            }
            ++i;
        }
    }

    private Coord getCenter(Collection<? extends Node> nodes) {
        double[] bBox = NetworkUtils.getBoundingBox(nodes);
        double minX = bBox[0];
        double minY = bBox[1];
        double maxX = bBox[2];
        double maxY = bBox[3];
        double centerX = (maxX - minX) / 2.0 + minX;
        double centerY = (maxY - minY) / 2.0 + minY;
        return new Coord(centerX, centerY);
    }

    public Node[] getLandmarks() {
        return (Node[])this.landmarks.clone();
    }
}

