/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;

public class PreProcessDijkstra {
    private static final Logger log = Logger.getLogger(PreProcessDijkstra.class);
    private boolean containsData = false;
    protected Map<Node, DeadEndData> nodeData = null;

    public void run(Network network) {
        this.markDeadEnds(network);
        this.containsData = true;
    }

    /*
     * WARNING - void declaration
     */
    private void markDeadEnds(Network network) {
        DeadEndData deadEndData;
        long now = System.currentTimeMillis();
        this.nodeData = new ConcurrentHashMap<Node, DeadEndData>(network.getNodes().size());
        for (Node node : network.getNodes().values()) {
            void var7_10;
            deadEndData = this.getNodeData(node);
            Map<Id<Node>, Node> map = PreProcessDijkstra.getIncidentNodes(node);
            if (map.size() != 1) continue;
            ArrayList<Object> deadEndNodes = new ArrayList<Object>();
            while (deadEndData.getInDeadEndCount() == var7_10.size() - 1) {
                void var6_6;
                deadEndNodes.add(var6_6);
                deadEndNodes.addAll(deadEndData.getDeadEndNodes());
                deadEndData.getDeadEndNodes().clear();
                deadEndData.setDeadEndEntryNode((Node)var6_6);
                Iterator it = var7_10.values().iterator();
                while (deadEndData.getDeadEndEntryNode() != null && it.hasNext()) {
                    Node node2 = (Node)it.next();
                    deadEndData = this.getNodeData(node2);
                }
                if (deadEndData.getDeadEndEntryNode() == null) {
                    deadEndData.incrementInDeadEndCount();
                    Map<Id<Node>, Node> map2 = PreProcessDijkstra.getIncidentNodes((Node)var6_6);
                    continue;
                }
                log.error("All " + var7_10.size() + " incident nodes of node " + var6_6.getId() + " are dead ends!");
                return;
            }
            deadEndData.getDeadEndNodes().addAll(deadEndNodes);
        }
        int deadEndNodeCount = 0;
        for (Node node : network.getNodes().values()) {
            deadEndData = this.getNodeData(node);
            for (Node n : deadEndData.getDeadEndNodes()) {
                DeadEndData r = this.getNodeData(n);
                r.setDeadEndEntryNode(node);
                ++deadEndNodeCount;
            }
            deadEndData.getDeadEndNodes().clear();
        }
        log.info("nodes in dead ends: " + deadEndNodeCount + " (total nodes: " + network.getNodes().size() + "). Done in " + (System.currentTimeMillis() - now) + " ms");
    }

    private static Map<Id<Node>, Node> getIncidentNodes(Node node) {
        TreeMap<Id<Node>, Node> nodes = new TreeMap<Id<Node>, Node>();
        for (Link link : node.getInLinks().values()) {
            nodes.put(link.getFromNode().getId(), link.getFromNode());
        }
        for (Link link : node.getOutLinks().values()) {
            nodes.put(link.getToNode().getId(), link.getToNode());
        }
        return nodes;
    }

    public DeadEndData getNodeData(Node n) {
        DeadEndData r = this.nodeData.get(n);
        if (null == r) {
            r = new DeadEndData();
            this.nodeData.put(n, r);
        }
        return r;
    }

    public boolean containsData() {
        return this.containsData;
    }

    public static class DeadEndData {
        private Node deadEndEntryNode = null;
        private int inDeadEndCount = 0;
        private ArrayList<Node> deadEndNodes = new ArrayList(2);

        ArrayList<Node> getDeadEndNodes() {
            return this.deadEndNodes;
        }

        int getInDeadEndCount() {
            return this.inDeadEndCount;
        }

        void incrementInDeadEndCount() {
            ++this.inDeadEndCount;
        }

        public Node getDeadEndEntryNode() {
            return this.deadEndEntryNode;
        }

        void setDeadEndEntryNode(Node node) {
            this.deadEndEntryNode = node;
        }
    }
}

