/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.utils.geometry.CoordUtils;

public class PreProcessEuclidean
extends PreProcessDijkstra {
    private static final Logger log = Logger.getLogger(PreProcessEuclidean.class);
    private double minTravelCostPerLength = Double.POSITIVE_INFINITY;
    protected TravelDisutility costFunction;

    public PreProcessEuclidean(TravelDisutility costFunction) {
        this.costFunction = costFunction;
    }

    @Override
    public void run(Network network) {
        super.run(network);
        if (!this.checkLinkLengths(network)) {
            log.warn("There are links with stored length smaller than their Euclidean distance in this network. Thus, A* cannot guarantee to calculate the least-cost paths between two nodes.");
        }
        this.updateMinTravelCostPerLength(network);
    }

    private void updateMinTravelCostPerLength(Network network) {
        for (Link link : network.getLinks().values()) {
            double minCost = this.costFunction.getLinkMinimumTravelDisutility(link) / link.getLength();
            if (!(this.getMinTravelCostPerLength() > minCost)) continue;
            this.setMinTravelCostPerLength(minCost);
        }
    }

    private boolean checkLinkLengths(Network network) {
        for (Link link : network.getLinks().values()) {
            double eucDist;
            double linkLength = link.getLength();
            if (!(linkLength < (eucDist = CoordUtils.calcEuclideanDistance(link.getFromNode().getCoord(), link.getToNode().getCoord())))) continue;
            if (log.isDebugEnabled()) {
                log.debug("link " + link.getId() + " has length " + linkLength + " which is smaller than the euclidean distance " + eucDist);
            }
            return false;
        }
        return true;
    }

    void setMinTravelCostPerLength(double maxFreeSpeed) {
        this.minTravelCostPerLength = maxFreeSpeed;
    }

    public double getMinTravelCostPerLength() {
        return this.minTravelCostPerLength;
    }

    public TravelDisutility getCostFunction() {
        return this.costFunction;
    }
}

