/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.MatsimComparator;
import org.matsim.core.router.util.Landmarker;
import org.matsim.core.router.util.PieSlicesLandmarker;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.PreProcessEuclidean;
import org.matsim.core.router.util.TravelDisutility;

public class PreProcessLandmarks
extends PreProcessEuclidean {
    private final int landmarkCount;
    private final Landmarker landmarker;
    private Node[] landmarks;
    private int numberOfThreads = 8;
    private static final Logger log = Logger.getLogger(PreProcessLandmarks.class);

    public PreProcessLandmarks(TravelDisutility costFunction) {
        this(costFunction, new Rectangle2D.Double());
    }

    public PreProcessLandmarks(TravelDisutility costFunction, int landmarkCount) {
        this(costFunction, new Rectangle2D.Double(), landmarkCount);
    }

    public PreProcessLandmarks(TravelDisutility costFunction, Rectangle2D.Double travelZone) {
        this(costFunction, travelZone, 16);
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public PreProcessLandmarks(TravelDisutility costFunction, Rectangle2D.Double travelZone, int landmarkCount) {
        this(costFunction, new PieSlicesLandmarker(travelZone), landmarkCount);
    }

    public PreProcessLandmarks(TravelDisutility costFunction, Landmarker landmarker, int landmarkCount) {
        super(costFunction);
        this.landmarkCount = landmarkCount;
        this.landmarker = landmarker;
    }

    @Override
    public void run(Network network) {
        LandmarksData r;
        super.run(network);
        log.info("Putting landmarks on network...");
        long now = System.currentTimeMillis();
        this.landmarks = this.landmarker.identifyLandmarks(this.landmarkCount, network);
        log.info("done in " + (System.currentTimeMillis() - now) + " ms");
        log.info("Initializing landmarks data");
        for (Node node : network.getNodes().values()) {
            this.nodeData.put(node, new LandmarksData(this.landmarkCount));
        }
        int nOfThreads = this.numberOfThreads;
        if (nOfThreads > this.landmarks.length) {
            nOfThreads = this.landmarks.length;
        }
        if (nOfThreads < 2) {
            nOfThreads = 2;
        }
        log.info("Calculating distance from each node to each of the " + this.landmarkCount + " landmarks using " + nOfThreads + " threads...");
        now = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(nOfThreads);
        for (int i = 0; i < this.landmarks.length; ++i) {
            executorService.execute(new Calculator(i, this.landmarks[i], this.nodeData, this.costFunction));
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            log.info("wait for landmarks Calculator to finish...");
            try {
                executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Node node : network.getNodes().values()) {
            r = this.getNodeData(node);
            r.updateMinMaxTravelTimes();
        }
        for (Node node : network.getNodes().values()) {
            r = this.getNodeData(node);
            for (int i = 0; i < this.landmarks.length; ++i) {
                if (!(r.getMinLandmarkTravelTime(i) > r.getMaxLandmarkTravelTime(i))) continue;
                log.info("Min > max for node " + node.getId() + " and landmark " + i);
            }
        }
        log.info("done in " + (System.currentTimeMillis() - now) + " ms");
    }

    public Node[] getLandmarks() {
        return (Node[])this.landmarks.clone();
    }

    @Override
    public LandmarksData getNodeData(Node n) {
        PreProcessDijkstra.DeadEndData r = (PreProcessDijkstra.DeadEndData)this.nodeData.get(n);
        if (r == null) {
            r = new LandmarksData(this.landmarkCount);
            this.nodeData.put(n, r);
        }
        return (LandmarksData)r;
    }

    private static class LandmarksFromTravelTimeComparator
    implements Comparator<Node>,
    MatsimComparator {
        private final Map<Node, PreProcessDijkstra.DeadEndData> roleData;
        private final int landmarkIndex;

        protected LandmarksFromTravelTimeComparator(Map<Node, PreProcessDijkstra.DeadEndData> roleData, int landmarkIndex) {
            this.roleData = roleData;
            this.landmarkIndex = landmarkIndex;
        }

        @Override
        public int compare(Node n1, Node n2) {
            double c2;
            double c1 = ((LandmarksData)this.roleData.get(n1)).getFromLandmarkTravelTime(this.landmarkIndex);
            if (c1 < (c2 = ((LandmarksData)this.roleData.get(n2)).getFromLandmarkTravelTime(this.landmarkIndex))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return n1.getId().compareTo(n2.getId());
        }
    }

    private static class LandmarksToTravelTimeComparator
    implements Comparator<Node>,
    MatsimComparator {
        private final Map<Node, PreProcessDijkstra.DeadEndData> roleData;
        private final int landmarkIndex;

        protected LandmarksToTravelTimeComparator(Map<Node, PreProcessDijkstra.DeadEndData> roleData, int landmarkIndex) {
            this.roleData = roleData;
            this.landmarkIndex = landmarkIndex;
        }

        @Override
        public int compare(Node n1, Node n2) {
            double c2;
            double c1 = ((LandmarksData)this.roleData.get(n1)).getToLandmarkTravelTime(this.landmarkIndex);
            if (c1 < (c2 = ((LandmarksData)this.roleData.get(n2)).getToLandmarkTravelTime(this.landmarkIndex))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return n1.getId().compareTo(n2.getId());
        }
    }

    public static class LandmarksData
    extends PreProcessDijkstra.DeadEndData {
        private final double[] landmarkTravelTime1;
        private final double[] landmarkTravelTime2;

        LandmarksData(int landmarkCount) {
            this.landmarkTravelTime2 = new double[landmarkCount];
            this.landmarkTravelTime1 = new double[landmarkCount];
            for (int i = 0; i < this.landmarkTravelTime2.length; ++i) {
                this.landmarkTravelTime2[i] = Double.POSITIVE_INFINITY;
                this.landmarkTravelTime1[i] = Double.POSITIVE_INFINITY;
            }
        }

        void setToLandmarkTravelTime(int landmarkIndex, double travelTime) {
            this.landmarkTravelTime2[landmarkIndex] = travelTime;
        }

        void setFromLandmarkTravelTime(int landmarkIndex, double travelTime) {
            this.landmarkTravelTime1[landmarkIndex] = travelTime;
        }

        double getToLandmarkTravelTime(int landmarkIndex) {
            return this.landmarkTravelTime2[landmarkIndex];
        }

        double getFromLandmarkTravelTime(int landmarkIndex) {
            return this.landmarkTravelTime1[landmarkIndex];
        }

        void updateMinMaxTravelTimes() {
            for (int i = 0; i < this.landmarkTravelTime1.length; ++i) {
                this.setTravelTimes(i, this.landmarkTravelTime2[i], this.landmarkTravelTime1[i]);
            }
        }

        private void setTravelTimes(int landmarkIndex, double travelTime1, double travelTime2) {
            if (travelTime1 > travelTime2) {
                this.landmarkTravelTime2[landmarkIndex] = travelTime1;
                this.landmarkTravelTime1[landmarkIndex] = travelTime2;
            } else {
                this.landmarkTravelTime1[landmarkIndex] = travelTime1;
                this.landmarkTravelTime2[landmarkIndex] = travelTime2;
            }
        }

        public double getMinLandmarkTravelTime(int landmarkIndex) {
            return this.landmarkTravelTime1[landmarkIndex];
        }

        public double getMaxLandmarkTravelTime(int landmarkIndex) {
            return this.landmarkTravelTime2[landmarkIndex];
        }
    }

    private static class Calculator
    implements Runnable {
        private final int landmarkIdx;
        private final Node landmark;
        private final Map<Node, PreProcessDijkstra.DeadEndData> nodeData;
        private final TravelDisutility costFunction;

        public Calculator(int landmarkIdx, Node landmark, Map<Node, PreProcessDijkstra.DeadEndData> nodeData, TravelDisutility costFunction) {
            this.landmarkIdx = landmarkIdx;
            this.landmark = landmark;
            this.nodeData = nodeData;
            this.costFunction = costFunction;
        }

        @Override
        public void run() {
            this.expandLandmarkFrom();
            this.expandLandmarkTo();
        }

        private void expandLandmarkFrom() {
            LandmarksFromTravelTimeComparator comparator = new LandmarksFromTravelTimeComparator(this.nodeData, this.landmarkIdx);
            PriorityQueue<Node> pendingNodes = new PriorityQueue<Node>(100, comparator);
            LandmarksData role = (LandmarksData)this.nodeData.get(this.landmark);
            role.setToLandmarkTravelTime(this.landmarkIdx, 0.0);
            role.setFromLandmarkTravelTime(this.landmarkIdx, 0.0);
            pendingNodes.add(this.landmark);
            while (!pendingNodes.isEmpty()) {
                Node node = pendingNodes.poll();
                double fromTravTime = ((LandmarksData)this.nodeData.get(node)).getFromLandmarkTravelTime(this.landmarkIdx);
                for (Link link : node.getOutLinks().values()) {
                    Node n = link.getToNode();
                    double linkTravTime = this.costFunction.getLinkMinimumTravelDisutility(link);
                    LandmarksData role2 = (LandmarksData)this.nodeData.get(n);
                    double totalTravelTime = fromTravTime + linkTravTime;
                    if (!(role2.getFromLandmarkTravelTime(this.landmarkIdx) > totalTravelTime)) continue;
                    role2.setFromLandmarkTravelTime(this.landmarkIdx, totalTravelTime);
                    pendingNodes.add(n);
                }
            }
        }

        private void expandLandmarkTo() {
            LandmarksToTravelTimeComparator comparator = new LandmarksToTravelTimeComparator(this.nodeData, this.landmarkIdx);
            PriorityQueue<Node> pendingNodes = new PriorityQueue<Node>(100, comparator);
            LandmarksData role = (LandmarksData)this.nodeData.get(this.landmark);
            role.setToLandmarkTravelTime(this.landmarkIdx, 0.0);
            role.setFromLandmarkTravelTime(this.landmarkIdx, 0.0);
            pendingNodes.add(this.landmark);
            while (!pendingNodes.isEmpty()) {
                Node node = pendingNodes.poll();
                double toTravTime = ((LandmarksData)this.nodeData.get(node)).getToLandmarkTravelTime(this.landmarkIdx);
                for (Link link : node.getInLinks().values()) {
                    Node n = link.getFromNode();
                    double linkTravTime = this.costFunction.getLinkMinimumTravelDisutility(link);
                    LandmarksData role2 = (LandmarksData)this.nodeData.get(n);
                    double totalTravelTime = toTravTime + linkTravTime;
                    if (!(role2.getToLandmarkTravelTime(this.landmarkIdx) > totalTravelTime)) continue;
                    role2.setToLandmarkTravelTime(this.landmarkIdx, totalTravelTime);
                    pendingNodes.add(n);
                }
            }
        }
    }
}

