/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scenario;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.Config;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.scenario.Lockable;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacilitiesImpl;
import org.matsim.households.Households;
import org.matsim.households.HouseholdsImpl;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesUtils;
import org.matsim.pt.transitSchedule.TransitScheduleFactoryImpl;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.vehicles.VehicleUtils;
import org.matsim.vehicles.Vehicles;

public final class MutableScenario
implements Scenario,
Lockable {
    private static final Logger log = Logger.getLogger(MutableScenario.class);
    private boolean locked = false;
    private final Map<String, Object> elements = new HashMap<String, Object>();
    private final Config config;
    private Network network;
    private Population population;
    private ActivityFacilities facilities;
    private TransitSchedule transitSchedule = null;
    private Lanes lanes = null;
    private Households households;
    private Vehicles transitVehicles;
    private Vehicles vehicles;

    MutableScenario(Config config) {
        this.config = config;
        this.network = NetworkUtils.createNetwork(this.config);
        this.population = PopulationUtils.createPopulation(this.config, this.network);
        this.facilities = new ActivityFacilitiesImpl();
        this.households = new HouseholdsImpl();
        this.lanes = LanesUtils.createLanesContainer();
        this.vehicles = VehicleUtils.createVehiclesContainer();
        this.transitVehicles = VehicleUtils.createVehiclesContainer();
        this.transitSchedule = new TransitScheduleFactoryImpl().createTransitSchedule();
        this.config.network().setLocked();
    }

    @Override
    public final ActivityFacilities getActivityFacilities() {
        return this.facilities;
    }

    @Override
    public final Network getNetwork() {
        return this.network;
    }

    @Override
    public final Population getPopulation() {
        return this.population;
    }

    @Override
    public final Config getConfig() {
        return this.config;
    }

    public final void setNetwork(Network network) {
        this.testForLocked();
        this.network = network;
    }

    public final void setPopulation(Population population) {
        this.testForLocked();
        this.population = population;
    }

    @Override
    public final Households getHouseholds() {
        return this.households;
    }

    @Override
    public Lanes getLanes() {
        return this.lanes;
    }

    @Override
    public final Vehicles getTransitVehicles() {
        return this.transitVehicles;
    }

    @Override
    public final Vehicles getVehicles() {
        return this.vehicles;
    }

    @Override
    public final TransitSchedule getTransitSchedule() {
        return this.transitSchedule;
    }

    @Override
    public final void addScenarioElement(String name, Object o) {
        if (o == null) {
            throw new NullPointerException(name);
        }
        Object former = this.elements.put(name, o);
        if (former != null) {
            throw new IllegalStateException(former + " is already associated with name " + name + " when adding " + o);
        }
    }

    public final Object removeScenarioElement(String name) {
        this.testForLocked();
        return this.elements.remove(name);
    }

    @Override
    public final Object getScenarioElement(String name) {
        return this.elements.get(name);
    }

    @Override
    public final void setLocked() {
        this.locked = true;
    }

    private void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("Scenario is locked; too late to do this.  See comments in code.");
        }
    }

    public final void setActivityFacilities(ActivityFacilities facilities) {
        this.testForLocked();
        this.facilities = facilities;
    }

    public final void setHouseholds(Households households) {
        this.testForLocked();
        this.households = households;
    }

    public final void setTransitSchedule(TransitSchedule schedule) {
        this.testForLocked();
        this.transitSchedule = schedule;
    }

    public final void setTransitVehicles(Vehicles vehicles) {
        this.testForLocked();
        this.transitVehicles = vehicles;
    }

    public final void setLanes(Lanes lanes) {
        this.testForLocked();
        this.lanes = lanes;
    }
}

