/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scenario;

import com.google.inject.Provides;
import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.controler.AbstractModule;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.households.Households;
import org.matsim.lanes.Lanes;
import org.matsim.pt.transitSchedule.api.Transit;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.vehicles.Vehicles;

public final class ScenarioByInstanceModule
extends AbstractModule {
    private final Scenario scenario;

    public ScenarioByInstanceModule(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public void install() {
        if (this.scenario != null) {
            this.bind(Scenario.class).toInstance(this.scenario);
        }
        if (this.getConfig().transit().isUseTransit()) {
            this.bind(TransitSchedule.class).toProvider(TransitScheduleProvider.class);
            this.bind(Vehicles.class).annotatedWith(Transit.class).toProvider(TransitVehiclesProvider.class);
        }
    }

    @Provides
    Network provideNetwork(Scenario scenario) {
        return scenario.getNetwork();
    }

    @Provides
    Population providePopulation(Scenario scenario) {
        return scenario.getPopulation();
    }

    @Provides
    PopulationFactory providePopulationFactory(Population population) {
        return population.getFactory();
    }

    @Provides
    ActivityFacilities provideActivityFacilities(Scenario scenario) {
        return scenario.getActivityFacilities();
    }

    @Provides
    Households provideHouseholds(Scenario scenario) {
        return scenario.getHouseholds();
    }

    @Provides
    Vehicles provideVehicles(Scenario scenario) {
        return scenario.getVehicles();
    }

    @Provides
    Lanes provideLanes(Scenario scenario) {
        return scenario.getLanes();
    }

    private static class TransitVehiclesProvider
    implements Provider<Vehicles> {
        @Inject
        Scenario scenario;

        private TransitVehiclesProvider() {
        }

        @Override
        public Vehicles get() {
            return this.scenario.getTransitVehicles();
        }
    }

    private static class TransitScheduleProvider
    implements Provider<TransitSchedule> {
        @Inject
        Scenario scenario;

        private TransitScheduleProvider() {
        }

        @Override
        public TransitSchedule get() {
            return this.scenario.getTransitSchedule();
        }
    }
}

