/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scenario;

import com.google.inject.Inject;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.network.io.NetworkChangeEventsParser;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.PopulationReader;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.facilities.MatsimFacilitiesReader;
import org.matsim.households.HouseholdsReaderV10;
import org.matsim.lanes.LanesReader;
import org.matsim.pt.transitSchedule.api.TransitScheduleReader;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.utils.objectattributes.ObjectAttributesUtils;
import org.matsim.utils.objectattributes.ObjectAttributesXmlReader;
import org.matsim.vehicles.VehicleReaderV1;

class ScenarioLoaderImpl {
    private static final Logger log = Logger.getLogger(ScenarioLoaderImpl.class);
    private final Config config;
    private final MutableScenario scenario;
    private Map<Class<?>, AttributeConverter<?>> attributeConverters = Collections.emptyMap();

    @Inject
    public void setAttributeConverters(Map<Class<?>, AttributeConverter<?>> attributeConverters) {
        log.debug("setting " + attributeConverters);
        this.attributeConverters = attributeConverters;
    }

    ScenarioLoaderImpl(Config config) {
        this.config = config;
        this.scenario = (MutableScenario)ScenarioUtils.createScenario(this.config);
    }

    ScenarioLoaderImpl(Scenario scenario) {
        this.scenario = (MutableScenario)scenario;
        this.config = this.scenario.getConfig();
    }

    Scenario loadScenario() {
        this.loadNetwork();
        this.loadActivityFacilities();
        this.loadPopulation();
        this.loadHouseholds();
        this.loadTransit();
        this.loadTransitVehicles();
        if (this.config.vehicles().getVehiclesFile() != null) {
            this.loadVehicles();
        }
        if (this.config.network().getLaneDefinitionsFile() != null) {
            this.loadLanes();
        }
        return this.scenario;
    }

    private void loadNetwork() {
        if (this.config.network() != null && this.config.network().getInputFile() != null) {
            URL networkUrl = this.config.network().getInputFileURL(this.config.getContext());
            log.info("loading network from " + networkUrl);
            String inputCRS = this.config.network().getInputCRS();
            MatsimNetworkReader reader = new MatsimNetworkReader(inputCRS, this.config.global().getCoordinateSystem(), this.scenario.getNetwork());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(networkUrl);
            if (this.config.network().getChangeEventsInputFile() != null && this.config.network().isTimeVariantNetwork()) {
                log.info("loading network change events from " + this.config.network().getChangeEventsInputFileUrl(this.config.getContext()).getFile());
                Network network = this.scenario.getNetwork();
                ArrayList<NetworkChangeEvent> changeEvents = new ArrayList<NetworkChangeEvent>();
                NetworkChangeEventsParser parser = new NetworkChangeEventsParser(network, changeEvents);
                parser.parse(this.config.network().getChangeEventsInputFileUrl(this.config.getContext()));
                NetworkUtils.setNetworkChangeEvents(network, changeEvents);
            }
        }
    }

    private void loadActivityFacilities() {
        if (this.config.facilities() != null && this.config.facilities().getInputFile() != null) {
            URL facilitiesFileName = this.config.facilities().getInputFileURL(this.config.getContext());
            log.info("loading facilities from " + facilitiesFileName);
            String inputCRS = this.config.facilities().getInputCRS();
            String internalCRS = this.config.global().getCoordinateSystem();
            MatsimFacilitiesReader reader = new MatsimFacilitiesReader(inputCRS, internalCRS, this.scenario.getActivityFacilities());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(facilitiesFileName);
            log.info("loaded " + this.scenario.getActivityFacilities().getFacilities().size() + " facilities from " + facilitiesFileName);
        } else {
            log.info("no facilities file set in config, therefore not loading any facilities.  This is not a problem except if you are using facilities");
        }
        if (this.config.facilities() != null && this.config.facilities().getInputFacilitiesAttributesFile() != null) {
            URL facilitiesAttributesURL = ConfigGroup.getInputFileURL(this.config.getContext(), this.config.facilities().getInputFacilitiesAttributesFile());
            log.info("loading facility attributes from " + facilitiesAttributesURL);
            ObjectAttributesXmlReader reader = new ObjectAttributesXmlReader(this.scenario.getActivityFacilities().getFacilityAttributes());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(facilitiesAttributesURL);
        } else {
            log.info("no facility-attributes file set in config, not loading any facility attributes");
        }
    }

    private void loadPopulation() {
        if (this.config.plans() != null && this.config.plans().getInputFile() != null) {
            URL populationFileName = this.config.plans().getInputFileURL(this.config.getContext());
            log.info("loading population from " + populationFileName);
            String targetCRS = this.config.global().getCoordinateSystem();
            String internalCRS = this.config.global().getCoordinateSystem();
            PopulationReader reader = new PopulationReader(targetCRS, internalCRS, this.scenario);
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(populationFileName);
            PopulationUtils.printPlansCount(this.scenario.getPopulation());
        } else {
            log.info("no population file set in config, not able to load population");
        }
        if (this.config.plans() != null && this.config.plans().getInputPersonAttributeFile() != null) {
            URL personAttributesURL = this.config.plans().getInputPersonAttributeFileURL(this.config.getContext());
            log.info("loading person attributes from " + personAttributesURL);
            ObjectAttributes personAttributes = new ObjectAttributes();
            ObjectAttributesXmlReader reader = new ObjectAttributesXmlReader(personAttributes);
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(personAttributesURL);
            for (Person person : this.scenario.getPopulation().getPersons().values()) {
                Collection<String> keys = ObjectAttributesUtils.getAllAttributeNames(personAttributes, person.getId().toString());
                for (String key : keys) {
                    Object value = personAttributes.getAttribute(person.getId().toString(), key);
                    person.getAttributes().putAttribute(key, value);
                }
                personAttributes.removeAllAttributes(person.getId().toString());
            }
            if (!personAttributes.toString().equals("")) {
                String message = "personAttributes not empty after going through all persons, meaning that it contains material for personIDs that are not in the population.  This is not necessarily a bug so we will continue, but note that such material will no longer be contained in the output_* files.  (We have this happening in particular when the same personAttributes file is used for the 10pct and the 1pct scenario. The material that is still there will follow.  kai, jun'19";
                log.warn(message);
                log.warn("showing the first 1000 characters from the remaining personAttributes ...");
                log.warn(personAttributes.toString().substring(0, 1000));
                log.warn("");
            }
            String outputDirectory = this.config.controler().getOutputDirectory();
            File file = new File(outputDirectory);
            if (!this.config.plans().isInsistingOnUsingDeprecatedPersonAttributeFile()) {
                throw new RuntimeException("using the separate person attribute file is deprecated.  Add the information directly into each person, using the Attributable feature.  If you insist on continuing to use the separate person attribute file, set insistingOnUsingDeprecatedPersonAttributeFile to true.  The file will then be read, but the values will be entered into each person using Attributable, and written as such to output_plans.  kai, may'19");
            }
        } else {
            log.info("no person-attributes file set in config, not loading any person attributes");
        }
    }

    private void loadHouseholds() {
        if (this.config.households() != null && this.config.households().getInputFile() != null) {
            URL householdsFile = this.config.households().getInputFileURL(this.config.getContext());
            log.info("loading households from " + householdsFile);
            new HouseholdsReaderV10(this.scenario.getHouseholds()).parse(householdsFile);
            log.info("households loaded.");
        } else {
            log.info("no households file set in config, not loading households");
        }
        String fn = this.config.households().getInputHouseholdAttributesFile();
        if (this.config.households() != null && fn != null) {
            URL householdAttributesFileName = ConfigGroup.getInputFileURL(this.config.getContext(), fn);
            log.info("loading household attributes from " + householdAttributesFileName);
            ObjectAttributesXmlReader reader = new ObjectAttributesXmlReader(this.scenario.getHouseholds().getHouseholdAttributes());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(householdAttributesFileName);
        } else {
            log.info("no household-attributes file set in config, not loading any household attributes");
        }
    }

    private void loadTransit() throws UncheckedIOException {
        ObjectAttributesXmlReader reader;
        if (this.config.transit().getTransitScheduleFile() != null) {
            URL transitScheduleFile = this.config.transit().getTransitScheduleFileURL(this.config.getContext());
            String inputCRS = this.config.transit().getInputScheduleCRS();
            String internalCRS = this.config.global().getCoordinateSystem();
            new TransitScheduleReader(inputCRS, internalCRS, this.scenario).readURL(transitScheduleFile);
        } else {
            log.info("no transit schedule file set in config, not loading any transit schedule");
        }
        if (this.config.transit().getTransitLinesAttributesFile() != null) {
            URL transitLinesAttributesFileName = IOUtils.newUrl(this.config.getContext(), this.config.transit().getTransitLinesAttributesFile());
            log.info("loading transit lines attributes from " + transitLinesAttributesFileName);
            reader = new ObjectAttributesXmlReader(this.scenario.getTransitSchedule().getTransitLinesAttributes());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(transitLinesAttributesFileName);
        }
        if (this.config.transit().getTransitStopsAttributesFile() != null) {
            URL transitStopsAttributesURL = IOUtils.newUrl(this.config.getContext(), this.config.transit().getTransitStopsAttributesFile());
            log.info("loading transit stop facilities attributes from " + transitStopsAttributesURL);
            reader = new ObjectAttributesXmlReader(this.scenario.getTransitSchedule().getTransitStopsAttributes());
            reader.putAttributeConverters(this.attributeConverters);
            reader.parse(transitStopsAttributesURL);
        }
    }

    private void loadTransitVehicles() throws UncheckedIOException {
        String vehiclesFile = this.config.transit().getVehiclesFile();
        if (vehiclesFile != null) {
            log.info("loading transit vehicles from " + vehiclesFile);
            new VehicleReaderV1(this.scenario.getTransitVehicles()).parse(this.config.transit().getVehiclesFileURL(this.config.getContext()));
        } else {
            log.info("no transit vehicles file set in config, not loading any transit vehicles");
        }
    }

    private void loadVehicles() throws UncheckedIOException {
        String vehiclesFile = this.config.vehicles().getVehiclesFile();
        if (vehiclesFile != null) {
            log.info("loading vehicles from " + vehiclesFile);
            new VehicleReaderV1(this.scenario.getVehicles()).parse(IOUtils.newUrl(this.config.getContext(), vehiclesFile));
        } else {
            log.info("no vehicles file set in config, not loading any vehicles");
        }
    }

    private void loadLanes() {
        String filename = this.config.network().getLaneDefinitionsFile();
        if (filename != null) {
            LanesReader reader = new LanesReader(this.scenario);
            reader.readURL(ConfigGroup.getInputFileURL(this.config.getContext(), filename));
        } else {
            log.info("no lanes file set in config, not loading any lanes");
        }
    }
}

