/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scenario;

import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.Config;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioLoaderImpl;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.households.Households;
import org.matsim.lanes.Lanes;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.vehicles.Vehicles;

public final class ScenarioUtils {
    private ScenarioUtils() {
    }

    public static Scenario createScenario(Config config) {
        if (config == null) {
            throw new NullPointerException("config must not be null!");
        }
        return new MutableScenario(config);
    }

    public static MutableScenario createMutableScenario(Config config) {
        if (config == null) {
            throw new NullPointerException("config must not be null!");
        }
        return new MutableScenario(config);
    }

    public static Scenario loadScenario(Config config) {
        ScenarioLoaderImpl scenarioLoader = new ScenarioLoaderImpl(config);
        Scenario scenario = scenarioLoader.loadScenario();
        return scenario;
    }

    public static void loadScenario(Scenario scenario) {
        ScenarioLoaderImpl scenarioLoader = new ScenarioLoaderImpl(scenario);
        scenarioLoader.loadScenario();
    }

    public static final class ScenarioBuilder {
        private MutableScenario scenario;

        public ScenarioBuilder(Config config) {
            this.scenario = new MutableScenario(config);
        }

        public ScenarioBuilder addScenarioElement(String name, Object o) {
            this.scenario.addScenarioElement(name, o);
            return this;
        }

        public ScenarioBuilder setHouseholds(Households households) {
            this.scenario.setHouseholds(households);
            return this;
        }

        public ScenarioBuilder setTransitSchedule(TransitSchedule schedule) {
            this.scenario.setTransitSchedule(schedule);
            return this;
        }

        public ScenarioBuilder setVehicles(Vehicles vehicles) {
            this.scenario.setTransitVehicles(vehicles);
            return this;
        }

        public ScenarioBuilder setNetwork(Network network) {
            this.scenario.setNetwork(network);
            return this;
        }

        public ScenarioBuilder setPopulation(Population population) {
            this.scenario.setPopulation(population);
            return this;
        }

        public ScenarioBuilder setActivityFacilities(ActivityFacilities facilities) {
            this.scenario.setActivityFacilities(facilities);
            return this;
        }

        public ScenarioBuilder setLanes(Lanes lanes) {
            this.scenario.setLanes(lanes);
            return this;
        }

        public Scenario build() {
            this.scenario.setLocked();
            return this.scenario;
        }
    }
}

