/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.scoring.PersonExperiencedActivity;

public final class EventsToActivities
implements ActivityStartEventHandler,
ActivityEndEventHandler {
    private Map<Id<Person>, Activity> activities = new HashMap<Id<Person>, Activity>();
    private List<ActivityHandler> activityHandlers = new ArrayList<ActivityHandler>();

    public EventsToActivities() {
    }

    @Inject
    EventsToActivities(ControlerListenerManager controlerListenerManager) {
        controlerListenerManager.addControlerListener(new AfterMobsimListener(){

            @Override
            public void notifyAfterMobsim(AfterMobsimEvent event) {
                EventsToActivities.this.finish();
            }
        });
    }

    @Override
    public void handleEvent(ActivityEndEvent event) {
        Activity activity = this.activities.remove(event.getPersonId());
        if (activity == null) {
            Activity firstActivity = PopulationUtils.createActivityFromLinkId(event.getActType(), event.getLinkId());
            firstActivity.setFacilityId(event.getFacilityId());
            activity = firstActivity;
        }
        activity.setEndTime(event.getTime());
        for (ActivityHandler activityHandler : this.activityHandlers) {
            activityHandler.handleActivity(new PersonExperiencedActivity(event.getPersonId(), activity));
        }
    }

    @Override
    public void handleEvent(ActivityStartEvent event) {
        Activity activity = PopulationUtils.createActivityFromLinkId(event.getActType(), event.getLinkId());
        activity.setFacilityId(event.getFacilityId());
        activity.setStartTime(event.getTime());
        this.activities.put(event.getPersonId(), activity);
    }

    @Override
    public void reset(int iteration) {
        this.activities.clear();
    }

    public void addActivityHandler(ActivityHandler activityHandler) {
        this.activityHandlers.add(activityHandler);
    }

    public void finish() {
        for (Map.Entry<Id<Person>, Activity> entry : this.activities.entrySet()) {
            for (ActivityHandler activityHandler : this.activityHandlers) {
                activityHandler.handleActivity(new PersonExperiencedActivity(entry.getKey(), entry.getValue()));
            }
        }
    }

    public static interface ActivityHandler {
        public void handleActivity(PersonExperiencedActivity var1);
    }
}

