/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.TransitDriverStartsEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.api.experimental.events.TeleportationArrivalEvent;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.TeleportationArrivalEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.scoring.PersonExperiencedLeg;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public final class EventsToLegs
implements PersonDepartureEventHandler,
PersonArrivalEventHandler,
LinkLeaveEventHandler,
LinkEnterEventHandler,
TeleportationArrivalEventHandler,
TransitDriverStartsEventHandler,
PersonEntersVehicleEventHandler,
VehicleArrivesAtFacilityEventHandler,
VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler {
    private Vehicle2DriverEventHandler delegate = new Vehicle2DriverEventHandler();
    private Network network;
    private TransitSchedule transitSchedule = null;
    private Map<Id<Person>, Leg> legs = new HashMap<Id<Person>, Leg>();
    private Map<Id<Person>, List<Id<Link>>> experiencedRoutes = new HashMap<Id<Person>, List<Id<Link>>>();
    private Map<Id<Person>, Double> relPosOnDepartureLinkPerPerson = new HashMap<Id<Person>, Double>();
    private Map<Id<Person>, Double> relPosOnArrivalLinkPerPerson = new HashMap<Id<Person>, Double>();
    private Map<Id<Person>, TeleportationArrivalEvent> routelessTravels = new HashMap<Id<Person>, TeleportationArrivalEvent>();
    private Map<Id<Person>, PendingTransitTravel> transitTravels = new HashMap<Id<Person>, PendingTransitTravel>();
    private Map<Id<Vehicle>, LineAndRoute> transitVehicle2currentRoute = new HashMap<Id<Vehicle>, LineAndRoute>();
    private List<LegHandler> legHandlers = new ArrayList<LegHandler>();

    @Inject(optional=true)
    public void setTransitSchedule(TransitSchedule transitSchedule) {
        this.transitSchedule = transitSchedule;
    }

    @Inject
    EventsToLegs(Network network) {
        this.network = network;
    }

    public EventsToLegs(Scenario scenario) {
        this.network = scenario.getNetwork();
        if (scenario.getConfig().transit().isUseTransit()) {
            this.transitSchedule = scenario.getTransitSchedule();
        }
    }

    @Override
    public void reset(int iteration) {
        this.legs.clear();
        this.experiencedRoutes.clear();
        this.transitTravels.clear();
        this.routelessTravels.clear();
        this.transitVehicle2currentRoute.clear();
        this.delegate.reset(iteration);
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        Leg leg = PopulationUtils.createLeg(event.getLegMode());
        leg.setDepartureTime(event.getTime());
        this.legs.put(event.getPersonId(), leg);
        ArrayList<Id<Link>> route = new ArrayList<Id<Link>>();
        route.add(event.getLinkId());
        this.experiencedRoutes.put(event.getPersonId(), route);
    }

    @Override
    public void handleEvent(PersonEntersVehicleEvent event) {
        LineAndRoute lineAndRoute = this.transitVehicle2currentRoute.get(event.getVehicleId());
        if (lineAndRoute != null && !event.getPersonId().equals(lineAndRoute.driverId)) {
            this.transitTravels.put(event.getPersonId(), new PendingTransitTravel(event.getVehicleId(), lineAndRoute.lastFacilityId));
        }
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        Id<Person> driverOfVehicle = this.delegate.getDriverOfVehicle(event.getVehicleId());
        List<Id<Link>> route = this.experiencedRoutes.get(driverOfVehicle);
        route.add(event.getLinkId());
    }

    @Override
    public void handleEvent(TeleportationArrivalEvent travelEvent) {
        this.routelessTravels.put(travelEvent.getPersonId(), travelEvent);
    }

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        LineAndRoute lineAndRoute = this.transitVehicle2currentRoute.get(event.getVehicleId());
        if (lineAndRoute != null) {
            lineAndRoute.lastFacilityId = event.getFacilityId();
        }
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        Leg leg = this.legs.get(event.getPersonId());
        leg.setTravelTime(event.getTime() - leg.getDepartureTime());
        double travelTime = leg.getDepartureTime() + leg.getTravelTime() - leg.getDepartureTime();
        leg.setTravelTime(travelTime);
        List<Id<Link>> experiencedRoute = this.experiencedRoutes.get(event.getPersonId());
        assert (experiencedRoute.size() >= 1);
        if (experiencedRoute.size() > 1) {
            NetworkRoute networkRoute = RouteUtils.createNetworkRoute(experiencedRoute, null);
            networkRoute.setTravelTime(travelTime);
            double relPosOnDepartureLink = this.relPosOnDepartureLinkPerPerson.get(event.getPersonId());
            Double relPosOnArrivalLink = this.relPosOnArrivalLinkPerPerson.get(event.getPersonId());
            Gbl.assertNotNull(relPosOnArrivalLink);
            networkRoute.setDistance(RouteUtils.calcDistance(networkRoute, relPosOnDepartureLink, relPosOnArrivalLink, this.network));
            leg.setRoute(networkRoute);
        } else {
            PendingTransitTravel pendingTransitTravel = this.transitTravels.remove(event.getPersonId());
            if (pendingTransitTravel != null) {
                LineAndRoute lineAndRoute = this.transitVehicle2currentRoute.get(pendingTransitTravel.vehicleId);
                assert (lineAndRoute != null);
                TransitStopFacility accessFacility = this.transitSchedule.getFacilities().get(pendingTransitTravel.accessStop);
                assert (accessFacility != null);
                TransitLine line = this.transitSchedule.getTransitLines().get(lineAndRoute.transitLineId);
                assert (line != null);
                TransitRoute route = line.getRoutes().get(lineAndRoute.transitRouteId);
                assert (route != null);
                Id<TransitStopFacility> lastFacilityId = lineAndRoute.lastFacilityId;
                if (lastFacilityId == null) {
                    Logger.getLogger(this.getClass()).warn("breakpoint");
                }
                assert (lastFacilityId != null);
                TransitStopFacility egressFacility = this.transitSchedule.getFacilities().get(lastFacilityId);
                assert (egressFacility != null);
                ExperimentalTransitRoute experimentalTransitRoute = new ExperimentalTransitRoute(accessFacility, line, route, egressFacility);
                experimentalTransitRoute.setTravelTime(travelTime);
                experimentalTransitRoute.setDistance(RouteUtils.calcDistance(experimentalTransitRoute, this.transitSchedule, this.network));
                leg.setRoute(experimentalTransitRoute);
            } else {
                TeleportationArrivalEvent travelEvent = this.routelessTravels.remove(event.getPersonId());
                Route genericRoute = RouteUtils.createGenericRouteImpl(experiencedRoute.get(0), event.getLinkId());
                genericRoute.setTravelTime(travelTime);
                if (travelEvent != null) {
                    genericRoute.setDistance(travelEvent.getDistance());
                } else {
                    genericRoute.setDistance(0.0);
                }
                leg.setRoute(genericRoute);
            }
        }
        for (LegHandler legHandler : this.legHandlers) {
            legHandler.handleLeg(new PersonExperiencedLeg(event.getPersonId(), leg));
        }
    }

    @Override
    public void handleEvent(TransitDriverStartsEvent event) {
        LineAndRoute lineAndRoute = new LineAndRoute(event.getTransitLineId(), event.getTransitRouteId(), event.getDriverId());
        this.transitVehicle2currentRoute.put(event.getVehicleId(), lineAndRoute);
    }

    public void addLegHandler(LegHandler legHandler) {
        this.legHandlers.add(legHandler);
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.delegate.handleEvent(event);
        this.relPosOnDepartureLinkPerPerson.put(event.getPersonId(), event.getRelativePositionOnLink());
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.delegate.handleEvent(event);
        this.relPosOnArrivalLinkPerPerson.put(event.getPersonId(), event.getRelativePositionOnLink());
    }

    public static interface LegHandler {
        public void handleLeg(PersonExperiencedLeg var1);
    }

    private static class LineAndRoute {
        final Id<TransitLine> transitLineId;
        final Id<TransitRoute> transitRouteId;
        final Id<Person> driverId;
        Id<TransitStopFacility> lastFacilityId;

        LineAndRoute(Id<TransitLine> transitLineId, Id<TransitRoute> transitRouteId, Id<Person> driverId) {
            this.transitLineId = transitLineId;
            this.transitRouteId = transitRouteId;
            this.driverId = driverId;
        }

        public String toString() {
            return "[" + super.toString() + " transitLineId=" + this.transitLineId + " transitRouteId=" + this.transitRouteId + " driverId=" + this.driverId + " lastFacilityId=" + this.lastFacilityId + "]";
        }
    }

    private static class PendingTransitTravel {
        final Id<Vehicle> vehicleId;
        final Id<TransitStopFacility> accessStop;

        public PendingTransitTravel(Id<Vehicle> vehicleId, Id<TransitStopFacility> accessStop) {
            this.vehicleId = vehicleId;
            this.accessStop = accessStop;
        }
    }
}

