/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import com.google.inject.Injector;
import javax.inject.Inject;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.ControlerListenerManagerImpl;
import org.matsim.core.events.EventsManagerModule;
import org.matsim.core.scenario.ScenarioByInstanceModule;
import org.matsim.core.scoring.ExperiencedPlansModule;
import org.matsim.core.scoring.NewScoreAssigner;
import org.matsim.core.scoring.NewScoreAssignerImpl;
import org.matsim.core.scoring.ScoringFunction;
import org.matsim.core.scoring.ScoringFunctionFactory;
import org.matsim.core.scoring.ScoringFunctionsForPopulation;

public final class EventsToScore {
    private final NewScoreAssigner newScoreAssigner;
    private final ControlerListenerManagerImpl controlerListenerManager;
    private ScoringFunctionsForPopulation scoringFunctionsForPopulation;
    private final Population population;
    private boolean finished = false;
    private int iteration = -1;

    @Inject
    private EventsToScore(ControlerListenerManagerImpl controlerListenerManager, ScoringFunctionsForPopulation scoringFunctionsForPopulation, Scenario scenario, NewScoreAssigner newScoreAssigner) {
        this.controlerListenerManager = controlerListenerManager;
        this.scoringFunctionsForPopulation = scoringFunctionsForPopulation;
        this.population = scenario.getPopulation();
        this.newScoreAssigner = newScoreAssigner;
    }

    public static EventsToScore createWithScoreUpdating(Scenario scenario, final ScoringFunctionFactory scoringFunctionFactory, final EventsManager eventsManager) {
        Injector injector = org.matsim.core.controler.Injector.createInjector(scenario.getConfig(), new ScenarioByInstanceModule(scenario), new ExperiencedPlansModule(), new AbstractModule(){

            @Override
            public void install() {
                this.bind(ScoringFunctionsForPopulation.class).asEagerSingleton();
                this.bind(ScoringFunctionFactory.class).toInstance(scoringFunctionFactory);
                this.bind(NewScoreAssigner.class).to(NewScoreAssignerImpl.class).asEagerSingleton();
                this.bind(EventsToScore.class).asEagerSingleton();
                this.bind(ControlerListenerManagerImpl.class).asEagerSingleton();
                this.bind(ControlerListenerManager.class).to(ControlerListenerManagerImpl.class);
                this.bind(EventsManager.class).toInstance(eventsManager);
                this.bind(EventsManagerModule.EventHandlerRegistrator.class).asEagerSingleton();
            }
        });
        return injector.getInstance(EventsToScore.class);
    }

    public static EventsToScore createWithoutScoreUpdating(Scenario scenario, final ScoringFunctionFactory scoringFunctionFactory, final EventsManager eventsManager) {
        Injector injector = org.matsim.core.controler.Injector.createInjector(scenario.getConfig(), new ScenarioByInstanceModule(scenario), new ExperiencedPlansModule(), new AbstractModule(){

            @Override
            public void install() {
                this.bind(ScoringFunctionsForPopulation.class).asEagerSingleton();
                this.bind(ScoringFunctionFactory.class).toInstance(scoringFunctionFactory);
                this.bind(NewScoreAssigner.class).to(NoopNewScoreAssignerImpl.class).asEagerSingleton();
                this.bind(EventsToScore.class).asEagerSingleton();
                this.bind(ControlerListenerManagerImpl.class).asEagerSingleton();
                this.bind(ControlerListenerManager.class).to(ControlerListenerManagerImpl.class);
                this.bind(EventsManager.class).toInstance(eventsManager);
                this.bind(EventsManagerModule.EventHandlerRegistrator.class).asEagerSingleton();
            }
        });
        return injector.getInstance(EventsToScore.class);
    }

    public void beginIteration(int iteration) {
        this.iteration = iteration;
        this.controlerListenerManager.fireControlerIterationStartsEvent(iteration);
    }

    public void finish() {
        if (this.iteration == -1) {
            throw new RuntimeException("Please initialize me before the iteration starts.");
        }
        this.controlerListenerManager.fireControlerAfterMobsimEvent(this.iteration);
        this.scoringFunctionsForPopulation.finishScoringFunctions();
        this.newScoreAssigner.assignNewScores(this.iteration, this.scoringFunctionsForPopulation, this.population);
        this.finished = true;
    }

    public Double getAgentScore(Id<Person> agentId) {
        if (!this.finished) {
            throw new IllegalStateException("Must call finish first.");
        }
        ScoringFunction scoringFunction = this.scoringFunctionsForPopulation.getScoringFunctionForAgent(agentId);
        if (scoringFunction == null) {
            return null;
        }
        return scoringFunction.getScore();
    }

    private static class NoopNewScoreAssignerImpl
    implements NewScoreAssigner {
        private NoopNewScoreAssignerImpl() {
        }

        @Override
        public void assignNewScores(int iteration, ScoringFunctionsForPopulation scoringFunctionsForPopulation, Population population) {
        }
    }
}

