/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationWriter;
import org.matsim.core.config.Config;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.listener.IterationStartsListener;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.scoring.EventsToActivities;
import org.matsim.core.scoring.EventsToLegs;
import org.matsim.core.scoring.ExperiencedPlansService;
import org.matsim.core.scoring.PersonExperiencedActivity;
import org.matsim.core.scoring.PersonExperiencedLeg;
import org.matsim.core.scoring.ScoringFunctionsForPopulation;

class ExperiencedPlansServiceImpl
implements ExperiencedPlansService,
EventsToLegs.LegHandler,
EventsToActivities.ActivityHandler {
    private static final Logger log = Logger.getLogger(ExperiencedPlansServiceImpl.class);
    @Inject
    private Config config;
    @Inject
    private Population population;
    @Inject(optional=true)
    private ScoringFunctionsForPopulation scoringFunctionsForPopulation;
    private final Map<Id<Person>, Plan> agentRecords = new HashMap<Id<Person>, Plan>();

    @Inject
    ExperiencedPlansServiceImpl(ControlerListenerManager controlerListenerManager, EventsToActivities eventsToActivities, EventsToLegs eventsToLegs) {
        controlerListenerManager.addControlerListener(new IterationStartsListener(){

            @Override
            public void notifyIterationStarts(IterationStartsEvent event) {
                for (Person person : ExperiencedPlansServiceImpl.this.population.getPersons().values()) {
                    ExperiencedPlansServiceImpl.this.agentRecords.put(person.getId(), PopulationUtils.createPlan());
                }
            }
        });
        eventsToActivities.addActivityHandler(this);
        eventsToLegs.addLegHandler(this);
    }

    @Override
    public synchronized void handleLeg(PersonExperiencedLeg o) {
        Id<Person> agentId = o.getAgentId();
        Leg leg = o.getLeg();
        Plan plan = this.agentRecords.get(agentId);
        if (plan != null) {
            plan.addLeg(leg);
        }
    }

    @Override
    public synchronized void handleActivity(PersonExperiencedActivity o) {
        Id<Person> agentId = o.getAgentId();
        Activity activity = o.getActivity();
        Plan plan = this.agentRecords.get(agentId);
        if (plan != null) {
            this.agentRecords.get(agentId).addActivity(activity);
        }
    }

    @Override
    public void writeExperiencedPlans(String iterationFilename) {
        Population tmpPop = PopulationUtils.createPopulation(this.config);
        for (Map.Entry<Id<Person>, Plan> entry : this.agentRecords.entrySet()) {
            Person person = PopulationUtils.getFactory().createPerson(entry.getKey());
            Plan plan = entry.getValue();
            person.addPlan(plan);
            tmpPop.addPerson(person);
        }
        new PopulationWriter(tmpPop, null).write(iterationFilename);
    }

    @Override
    public final void finishIteration() {
        for (Map.Entry<Id<Person>, Plan> entry : this.agentRecords.entrySet()) {
            Plan plan = entry.getValue();
            if (this.scoringFunctionsForPopulation == null) continue;
            plan.setScore(this.scoringFunctionsForPopulation.getScoringFunctionForAgent(entry.getKey()).getScore());
            if (!plan.getScore().isNaN()) continue;
            log.warn("score is NaN; plan:" + plan.toString());
        }
    }

    @Override
    public Map<Id<Person>, Plan> getExperiencedPlans() {
        return this.agentRecords;
    }
}

