/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.scoring.NewScoreAssigner;
import org.matsim.core.scoring.ScoringFunction;
import org.matsim.core.scoring.ScoringFunctionsForPopulation;

class NewScoreAssignerImpl
implements NewScoreAssigner {
    private static final Logger log = Logger.getLogger(NewScoreAssignerImpl.class);
    private Map<Plan, Integer> msaContributions = new HashMap<Plan, Integer>();
    private Integer scoreMSAstartsAtIteration;
    private final double learningRate;
    private double scoreSum = 0.0;
    private long scoreCount = 0L;

    @Inject
    NewScoreAssignerImpl(PlanCalcScoreConfigGroup planCalcScoreConfigGroup, ControlerConfigGroup controlerConfigGroup) {
        if (planCalcScoreConfigGroup.getFractionOfIterationsToStartScoreMSA() != null) {
            int diff = controlerConfigGroup.getLastIteration() - controlerConfigGroup.getFirstIteration();
            this.scoreMSAstartsAtIteration = (int)((double)diff * planCalcScoreConfigGroup.getFractionOfIterationsToStartScoreMSA() + (double)controlerConfigGroup.getFirstIteration());
        }
        this.learningRate = planCalcScoreConfigGroup.getLearningRate();
    }

    @Override
    public void assignNewScores(int iteration, ScoringFunctionsForPopulation scoringFunctionsForPopulation, Population population) {
        log.info("it: " + iteration + " msaStart: " + this.scoreMSAstartsAtIteration);
        for (Person person : population.getPersons().values()) {
            ScoringFunction sf = scoringFunctionsForPopulation.getScoringFunctionForAgent(person.getId());
            double score = sf.getScore();
            Plan plan = (Plan)person.getSelectedPlan();
            Double oldScore = plan.getScore();
            if (oldScore == null) {
                plan.setScore(score);
                if (plan.getScore().isNaN()) {
                    log.warn("score is NaN; plan:" + plan.toString());
                }
            } else if (this.scoreMSAstartsAtIteration == null || iteration < this.scoreMSAstartsAtIteration) {
                double newScore = this.learningRate * score + (1.0 - this.learningRate) * oldScore;
                if (log.isTraceEnabled()) {
                    log.trace(" lrn: " + this.learningRate + " oldScore: " + oldScore + " simScore: " + score + " newScore: " + newScore);
                }
                plan.setScore(newScore);
                if (plan.getScore().isNaN()) {
                    log.warn("score is NaN; plan:" + plan.toString() + " with lrn: " + this.learningRate + " oldScore: " + oldScore + " simScore: " + score + " newScore: " + newScore);
                }
            } else {
                Integer msaContribs = this.msaContributions.get(plan);
                if (msaContribs == null) {
                    msaContribs = 0;
                }
                this.msaContributions.put(plan, msaContribs + 1);
                double alpha = 1.0 / (double)(msaContribs + 1);
                double newScore = alpha * score + (1.0 - alpha) * oldScore;
                if (log.isTraceEnabled()) {
                    log.trace(" alpha: " + alpha + " oldScore: " + oldScore + " simScore: " + score + " newScore: " + newScore);
                }
                plan.setScore(newScore);
                if (plan.getScore().isNaN()) {
                    log.warn("score is NaN; plan:" + plan.toString());
                }
            }
            this.scoreSum += score;
            ++this.scoreCount;
        }
    }
}

