/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.corelisteners.PlansScoring;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.ScoringEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.ScoringListener;
import org.matsim.core.scoring.ExperiencedPlansService;
import org.matsim.core.scoring.NewScoreAssignerImpl;
import org.matsim.core.scoring.ScoringFunctionsForPopulation;

@Singleton
final class PlansScoringImpl
implements PlansScoring,
ScoringListener,
IterationEndsListener {
    @Inject
    private PlanCalcScoreConfigGroup planCalcScoreConfigGroup;
    @Inject
    private ControlerConfigGroup controlerConfigGroup;
    @Inject
    private Population population;
    @Inject
    private OutputDirectoryHierarchy controlerIO;
    @Inject
    private ScoringFunctionsForPopulation scoringFunctionsForPopulation;
    @Inject
    private ExperiencedPlansService experiencedPlansService;

    PlansScoringImpl() {
    }

    @Override
    public void notifyScoring(ScoringEvent event) {
        this.scoringFunctionsForPopulation.finishScoringFunctions();
        NewScoreAssignerImpl newScoreAssigner = new NewScoreAssignerImpl(this.planCalcScoreConfigGroup, this.controlerConfigGroup);
        newScoreAssigner.assignNewScores(event.getIteration(), this.scoringFunctionsForPopulation, this.population);
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        int writePlansInterval;
        this.experiencedPlansService.finishIteration();
        if (this.planCalcScoreConfigGroup.isWriteExperiencedPlans() && (writePlansInterval = this.controlerConfigGroup.getWritePlansInterval()) > 0 && event.getIteration() % writePlansInterval == 0) {
            this.experiencedPlansService.writeExperiencedPlans(this.controlerIO.getIterationFilename(event.getIteration(), "experienced_plans.xml.gz"));
            this.scoringFunctionsForPopulation.writePartialScores(this.controlerIO.getIterationFilename(event.getIteration(), "experienced_plans_scores.txt.gz"));
        }
        if (this.planCalcScoreConfigGroup.isMemorizingExperiencedPlans()) {
            for (Person person : this.population.getPersons().values()) {
                Plan experiencedPlan = this.experiencedPlansService.getExperiencedPlans().get(person.getId());
                if (experiencedPlan == null) {
                    throw new RuntimeException("experienced plan is null; I don't think this should happen");
                }
                Plan selectedPlan = (Plan)person.getSelectedPlan();
                selectedPlan.getCustomAttributes().put("experiencedPlan", experiencedPlan);
            }
        }
    }
}

