/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import com.google.inject.Inject;
import gnu.trove.TDoubleCollection;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.PersonMoneyEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.internal.HasPersonId;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.listener.IterationStartsListener;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.events.handler.BasicEventHandler;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.scoring.EventsToActivities;
import org.matsim.core.scoring.EventsToLegs;
import org.matsim.core.scoring.PersonExperiencedActivity;
import org.matsim.core.scoring.PersonExperiencedLeg;
import org.matsim.core.scoring.ScoringFunction;
import org.matsim.core.scoring.ScoringFunctionFactory;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.vehicles.Vehicle;

final class ScoringFunctionsForPopulation
implements BasicEventHandler,
EventsToLegs.LegHandler,
EventsToActivities.ActivityHandler {
    private static final Logger log = Logger.getLogger(ScoringFunctionsForPopulation.class);
    private final Population population;
    private final ScoringFunctionFactory scoringFunctionFactory;
    private StageActivityTypes stageActivityTypes;
    private final Map<Id<Person>, ScoringFunction> agentScorers = new HashMap<Id<Person>, ScoringFunction>();
    private final Map<Id<Person>, TDoubleCollection> partialScores = new LinkedHashMap<Id<Person>, TDoubleCollection>();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final Map<Id<Person>, Plan> tripRecords = new LinkedHashMap<Id<Person>, Plan>();
    private Vehicle2DriverEventHandler vehicles2Drivers = new Vehicle2DriverEventHandler();
    @Inject(optional=true)
    private TripRouter tripRouter;

    @Inject
    ScoringFunctionsForPopulation(ControlerListenerManager controlerListenerManager, EventsManager eventsManager, EventsToActivities eventsToActivities, EventsToLegs eventsToLegs, Population population, ScoringFunctionFactory scoringFunctionFactory) {
        controlerListenerManager.addControlerListener(new IterationStartsListener(){

            @Override
            public void notifyIterationStarts(IterationStartsEvent event) {
                ScoringFunctionsForPopulation.this.init();
            }
        });
        this.population = population;
        this.scoringFunctionFactory = scoringFunctionFactory;
        eventsManager.addHandler(this);
        eventsToActivities.addActivityHandler(this);
        eventsToLegs.addLegHandler(this);
        eventsManager.addHandler(this.vehicles2Drivers);
    }

    private void init() {
        for (Person person : this.population.getPersons().values()) {
            ScoringFunction data = this.scoringFunctionFactory.createNewScoringFunction(person);
            this.agentScorers.put(person.getId(), data);
            this.partialScores.put(person.getId(), new TDoubleArrayList());
            this.tripRecords.put(person.getId(), PopulationUtils.createPlan());
        }
    }

    private StageActivityTypes getStageActivities() {
        if (this.stageActivityTypes == null) {
            this.stageActivityTypes = this.tripRouter != null ? this.tripRouter.getStageActivityTypes() : new StageActivityTypes(){

                @Override
                public boolean isStageActivity(String activityType) {
                    return activityType.contains("_interaction");
                }
            };
        }
        return this.stageActivityTypes;
    }

    @Override
    public synchronized void handleEvent(Event o) {
        Id<Vehicle> vehicleId;
        Id<Person> driverId;
        ScoringFunction scoringFunction;
        ScoringFunction scoringFunction2;
        if (o instanceof HasPersonId && (scoringFunction2 = this.getScoringFunctionForAgent(((HasPersonId)((Object)o)).getPersonId())) != null) {
            if (o instanceof PersonStuckEvent) {
                scoringFunction2.agentStuck(o.getTime());
            } else if (o instanceof PersonMoneyEvent) {
                scoringFunction2.addMoney(((PersonMoneyEvent)o).getAmount());
            }
            scoringFunction2.handleEvent(o);
        }
        if (o instanceof VehicleEntersTrafficEvent) {
            this.vehicles2Drivers.handleEvent((VehicleEntersTrafficEvent)o);
        }
        if (o instanceof VehicleLeavesTrafficEvent) {
            this.vehicles2Drivers.handleEvent((VehicleLeavesTrafficEvent)o);
        }
        if (o instanceof LinkEnterEvent && (scoringFunction = this.getScoringFunctionForAgent(driverId = this.vehicles2Drivers.getDriverOfVehicle(vehicleId = ((LinkEnterEvent)o).getVehicleId()))) != null) {
            scoringFunction.handleEvent(o);
        }
    }

    @Override
    public synchronized void handleLeg(PersonExperiencedLeg o) {
        Plan plan;
        Id<Person> agentId = o.getAgentId();
        Leg leg = o.getLeg();
        ScoringFunction scoringFunction = this.getScoringFunctionForAgent(agentId);
        if (scoringFunction != null) {
            scoringFunction.handleLeg(leg);
            TDoubleCollection partialScoresForAgent = this.partialScores.get(agentId);
            partialScoresForAgent.add(scoringFunction.getScore());
        }
        if ((plan = this.tripRecords.get(agentId)) != null) {
            plan.addLeg(leg);
        }
    }

    @Override
    public synchronized void handleActivity(PersonExperiencedActivity o) {
        Plan plan;
        Id<Person> agentId = o.getAgentId();
        Activity activity = o.getActivity();
        ScoringFunction scoringFunction = this.getScoringFunctionForAgent(agentId);
        if (scoringFunction != null) {
            scoringFunction.handleActivity(activity);
            TDoubleCollection partialScoresForAgent = this.partialScores.get(agentId);
            partialScoresForAgent.add(scoringFunction.getScore());
        }
        if ((plan = this.tripRecords.get(agentId)) != null) {
            if (!plan.getPlanElements().isEmpty() && !this.getStageActivities().isStageActivity(activity.getType())) {
                plan.addActivity(activity);
                List<TripStructureUtils.Trip> trips = TripStructureUtils.getTrips(plan, this.getStageActivities());
                for (TripStructureUtils.Trip trip : trips) {
                    if (trip == null) continue;
                    scoringFunction.handleTrip(trip);
                }
                plan.getPlanElements().clear();
            }
            plan.addActivity(activity);
        }
    }

    public ScoringFunction getScoringFunctionForAgent(Id<Person> agentId) {
        return this.agentScorers.get(agentId);
    }

    public void finishScoringFunctions() {
        Throwable throwable = this.exception.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        for (ScoringFunction scoringFunction : this.agentScorers.values()) {
            scoringFunction.finish();
        }
        for (Map.Entry entry : this.partialScores.entrySet()) {
            ((TDoubleCollection)entry.getValue()).add(this.getScoringFunctionForAgent((Id)entry.getKey()).getScore());
        }
    }

    public void writePartialScores(String iterationFilename) {
        try (BufferedWriter out = IOUtils.getBufferedWriter(iterationFilename);){
            for (Map.Entry<Id<Person>, TDoubleCollection> entry : this.partialScores.entrySet()) {
                out.write(entry.getKey().toString());
                TDoubleIterator iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    out.write('\t' + String.valueOf(iterator.next()));
                }
                out.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset(int iteration) {
    }
}

