/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.scoring.ScoringFunction;
import org.matsim.core.utils.misc.Time;

public final class SumScoringFunction
implements ScoringFunction {
    private static Logger log = Logger.getLogger(SumScoringFunction.class);
    private ArrayList<BasicScoring> basicScoringFunctions = new ArrayList();
    private ArrayList<ActivityScoring> activityScoringFunctions = new ArrayList();
    private ArrayList<MoneyScoring> moneyScoringFunctions = new ArrayList();
    private ArrayList<LegScoring> legScoringFunctions = new ArrayList();
    private ArrayList<TripScoring> tripScoringFunctions = new ArrayList();
    private ArrayList<AgentStuckScoring> agentStuckScoringFunctions = new ArrayList();
    private ArrayList<ArbitraryEventScoring> arbitraryEventScoringFunctions = new ArrayList();

    @Override
    public final void handleActivity(Activity activity) {
        double startTime = activity.getStartTime();
        double endTime = activity.getEndTime();
        if (Time.isUndefinedTime(startTime) && !Time.isUndefinedTime(endTime)) {
            for (ActivityScoring activityScoringFunction : this.activityScoringFunctions) {
                activityScoringFunction.handleFirstActivity(activity);
            }
        } else if (!Time.isUndefinedTime(startTime) && !Time.isUndefinedTime(endTime)) {
            for (ActivityScoring activityScoringFunction : this.activityScoringFunctions) {
                activityScoringFunction.handleActivity(activity);
            }
        } else if (!Time.isUndefinedTime(startTime) && Time.isUndefinedTime(endTime)) {
            for (ActivityScoring activityScoringFunction : this.activityScoringFunctions) {
                activityScoringFunction.handleLastActivity(activity);
            }
        } else {
            throw new RuntimeException("Trying to score an activity without start or end time. Should not happen. Activity=" + activity);
        }
    }

    @Override
    public final void handleLeg(Leg leg) {
        for (LegScoring legScoringFunction : this.legScoringFunctions) {
            legScoringFunction.handleLeg(leg);
        }
    }

    @Override
    public final void handleTrip(TripStructureUtils.Trip trip) {
        for (TripScoring tripScoringFunction : this.tripScoringFunctions) {
            tripScoringFunction.handleTrip(trip);
        }
    }

    @Override
    public void addMoney(double amount) {
        for (MoneyScoring moneyScoringFunction : this.moneyScoringFunctions) {
            moneyScoringFunction.addMoney(amount);
        }
    }

    @Override
    public void agentStuck(double time) {
        for (AgentStuckScoring agentStuckScoringFunction : this.agentStuckScoringFunctions) {
            agentStuckScoringFunction.agentStuck(time);
        }
    }

    @Override
    public void handleEvent(Event event) {
        for (ArbitraryEventScoring eventScoringFunction : this.arbitraryEventScoringFunctions) {
            eventScoringFunction.handleEvent(event);
        }
    }

    @Override
    public void finish() {
        for (BasicScoring basicScoringFunction : this.basicScoringFunctions) {
            basicScoringFunction.finish();
        }
    }

    @Override
    public double getScore() {
        double score = 0.0;
        for (BasicScoring basicScoringFunction : this.basicScoringFunctions) {
            double contribution = basicScoringFunction.getScore();
            if (log.isTraceEnabled()) {
                log.trace("Contribution of scoring function: " + basicScoringFunction.getClass().getName() + " is: " + contribution);
            }
            if (Double.isNaN(contribution)) {
                throw new RuntimeException("Contribution of scoring function: " + basicScoringFunction.getClass().getName() + " is NaN! Behavior with NaN scores is undefined.");
            }
            score += contribution;
        }
        return score;
    }

    public void addScoringFunction(BasicScoring scoringFunction) {
        this.basicScoringFunctions.add(scoringFunction);
        if (scoringFunction instanceof ActivityScoring) {
            this.activityScoringFunctions.add((ActivityScoring)scoringFunction);
        }
        if (scoringFunction instanceof AgentStuckScoring) {
            this.agentStuckScoringFunctions.add((AgentStuckScoring)scoringFunction);
        }
        if (scoringFunction instanceof LegScoring) {
            this.legScoringFunctions.add((LegScoring)scoringFunction);
        }
        if (scoringFunction instanceof TripScoring) {
            this.tripScoringFunctions.add((TripScoring)scoringFunction);
        }
        if (scoringFunction instanceof MoneyScoring) {
            this.moneyScoringFunctions.add((MoneyScoring)scoringFunction);
        }
        if (scoringFunction instanceof ArbitraryEventScoring) {
            this.arbitraryEventScoringFunctions.add((ArbitraryEventScoring)scoringFunction);
        }
    }

    public static interface ArbitraryEventScoring
    extends BasicScoring {
        public void handleEvent(Event var1);
    }

    public static interface AgentStuckScoring
    extends BasicScoring {
        public void agentStuck(double var1);
    }

    public static interface MoneyScoring
    extends BasicScoring {
        public void addMoney(double var1);
    }

    public static interface TripScoring
    extends BasicScoring {
        public void handleTrip(TripStructureUtils.Trip var1);
    }

    public static interface LegScoring
    extends BasicScoring {
        public void handleLeg(Leg var1);
    }

    public static interface ActivityScoring
    extends BasicScoring {
        public void handleFirstActivity(Activity var1);

        public void handleActivity(Activity var1);

        public void handleLastActivity(Activity var1);
    }

    public static interface BasicScoring {
        public void finish();

        public double getScore();
    }
}

