/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.scoring.functions.ActivityUtilityParameters;
import org.matsim.core.scoring.functions.OpeningIntervalCalculator;
import org.matsim.core.scoring.functions.ScoringParameters;

public class ActivityTypeOpeningIntervalCalculator
implements OpeningIntervalCalculator {
    private final ScoringParameters params;

    public ActivityTypeOpeningIntervalCalculator(ScoringParameters params) {
        this.params = params;
    }

    @Override
    public double[] getOpeningInterval(Activity act) {
        ActivityUtilityParameters actParams = this.params.utilParams.get(act.getType());
        if (actParams == null) {
            throw new IllegalArgumentException("acttype \"" + act.getType() + "\" is not known in utility parameters " + "(module name=\"planCalcScore\" in the config file).");
        }
        double openingTime = actParams.getOpeningTime();
        double closingTime = actParams.getClosingTime();
        return new double[]{openingTime, closingTime};
    }
}

