/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;

public final class ActivityUtilityParameters
implements MatsimParameters {
    private final String type;
    private double typicalDuration_s;
    private double zeroUtilityDuration_h;
    private double minimalDuration = -1.0;
    private double openingTime = -1.0;
    private double closingTime = -1.0;
    private double latestStartTime = -1.0;
    private double earliestEndTime = -1.0;
    private boolean scoreAtAll = true;

    ActivityUtilityParameters(String type) {
        this.type = type;
    }

    final void checkConsistency() {
        if (this.scoreAtAll && this.zeroUtilityDuration_h == 0.0) {
            throw new RuntimeException("zeroUtilityDuration of type " + this.type + " must be greater than 0.0. Did you forget to specify the typicalDuration?");
        }
    }

    final void setScoreAtAll(boolean scoreAtAll) {
        this.scoreAtAll = scoreAtAll;
    }

    final void setTypicalDuration(double typicalDuration_s) {
        this.typicalDuration_s = typicalDuration_s;
    }

    final void setZeroUtilityDuration_s(double val) {
        this.zeroUtilityDuration_h = val / 3600.0;
    }

    final void setMinimalDuration(double dur) {
        this.minimalDuration = dur;
    }

    final void setOpeningTime(double time) {
        this.openingTime = time;
    }

    final void setClosingTime(double time) {
        this.closingTime = time;
    }

    final void setLatestStartTime(double time) {
        this.latestStartTime = time;
    }

    final void setEarliestEndTime(double time) {
        this.earliestEndTime = time;
    }

    public final String getType() {
        return this.type;
    }

    public final double getTypicalDuration() {
        return this.typicalDuration_s;
    }

    public final double getZeroUtilityDuration_h() {
        return this.zeroUtilityDuration_h;
    }

    public final double getMinimalDuration() {
        return this.minimalDuration;
    }

    public final double getOpeningTime() {
        return this.openingTime;
    }

    public final double getClosingTime() {
        return this.closingTime;
    }

    public final double getLatestStartTime() {
        return this.latestStartTime;
    }

    public final double getEarliestEndTime() {
        return this.earliestEndTime;
    }

    public final boolean isScoreAtAll() {
        return this.scoreAtAll;
    }

    public static final class Builder {
        private String type;
        private double priority = 1.0;
        private double typicalDuration_s;
        private double closingTime;
        private double earliestEndTime;
        private double latestStartTime;
        private double minimalDuration;
        private double openingTime;
        private boolean scoreAtAll;
        private ZeroUtilityComputation zeroUtilityComputation;

        public Builder() {
        }

        public Builder(PlanCalcScoreConfigGroup.ActivityParams ppp) {
            this.type = ppp.getActivityType();
            this.priority = ppp.getPriority();
            this.typicalDuration_s = ppp.getTypicalDuration();
            this.closingTime = ppp.getClosingTime();
            this.earliestEndTime = ppp.getEarliestEndTime();
            this.latestStartTime = ppp.getLatestStartTime();
            this.minimalDuration = ppp.getMinimalDuration();
            this.openingTime = ppp.getOpeningTime();
            this.scoreAtAll = ppp.isScoringThisActivityAtAll();
            switch (ppp.getTypicalDurationScoreComputation()) {
                case relative: {
                    this.zeroUtilityComputation = new SameRelativeScore();
                    break;
                }
                case uniform: {
                    this.zeroUtilityComputation = new SameAbsoluteScore();
                    break;
                }
                default: {
                    throw new RuntimeException("not defined");
                }
            }
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setPriority(double priority) {
            this.priority = priority;
            return this;
        }

        public Builder setTypicalDuration_s(double typicalDurationS) {
            this.typicalDuration_s = typicalDurationS;
            return this;
        }

        public Builder setClosingTime(double closingTime) {
            this.closingTime = closingTime;
            return this;
        }

        public Builder setEarliestEndTime(double earliestEndTime) {
            this.earliestEndTime = earliestEndTime;
            return this;
        }

        public Builder setLatestStartTime(double latestStartTime) {
            this.latestStartTime = latestStartTime;
            return this;
        }

        public Builder setMinimalDuration(double minimalDuration) {
            this.minimalDuration = minimalDuration;
            return this;
        }

        public Builder setOpeningTime(double openingTime) {
            this.openingTime = openingTime;
            return this;
        }

        public Builder setScoreAtAll(boolean scoreAtAll) {
            this.scoreAtAll = scoreAtAll;
            return this;
        }

        public ActivityUtilityParameters build() {
            ActivityUtilityParameters params = new ActivityUtilityParameters(this.type);
            params.setScoreAtAll(this.scoreAtAll);
            params.setTypicalDuration(this.typicalDuration_s);
            params.setZeroUtilityDuration_s(this.zeroUtilityComputation.computeZeroUtilityDuration_s(this.priority, this.typicalDuration_s));
            params.setClosingTime(this.closingTime);
            params.setEarliestEndTime(this.earliestEndTime);
            params.setLatestStartTime(this.latestStartTime);
            params.setMinimalDuration(this.minimalDuration);
            params.setOpeningTime(this.openingTime);
            params.checkConsistency();
            return params;
        }

        public final Builder setZeroUtilityComputation(ZeroUtilityComputation zeroUtilityComputation) {
            this.zeroUtilityComputation = zeroUtilityComputation;
            return this;
        }
    }

    public static final class SameRelativeScore
    implements ZeroUtilityComputation {
        @Override
        public double computeZeroUtilityDuration_s(double priority, double typicalDuration_s) {
            double priority1 = priority;
            double typicalDuration_s1 = typicalDuration_s;
            double zeroUtilityDuration = typicalDuration_s1 * Math.exp(-1.0 / priority1);
            return zeroUtilityDuration;
        }
    }

    public static final class SameAbsoluteScore
    implements ZeroUtilityComputation {
        @Override
        public double computeZeroUtilityDuration_s(double priority, double typicalDuration_s) {
            double priority1 = priority;
            double typicalDuration_s1 = typicalDuration_s;
            double zeroUtilityDuration = typicalDuration_s1 * Math.exp(-10.0 / (typicalDuration_s1 / 3600.0) / priority1);
            return zeroUtilityDuration;
        }
    }

    public static interface ZeroUtilityComputation {
        public double computeZeroUtilityDuration_s(double var1, double var3);
    }
}

