/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.scoring.SumScoringFunction;
import org.matsim.core.scoring.functions.ActivityTypeOpeningIntervalCalculator;
import org.matsim.core.scoring.functions.ActivityUtilityParameters;
import org.matsim.core.scoring.functions.OpeningIntervalCalculator;
import org.matsim.core.scoring.functions.ScoringParameters;

public final class CharyparNagelActivityScoring
implements SumScoringFunction.ActivityScoring {
    private double score;
    private double currentActivityStartTime;
    private double firstActivityEndTime;
    private static final double INITIAL_LAST_TIME = 0.0;
    private static final double INITIAL_FIRST_ACT_END_TIME = Double.NEGATIVE_INFINITY;
    private static final double INITIAL_SCORE = 0.0;
    private static int firstLastActWarning = 0;
    private static short firstLastActOpeningTimesWarning = 0;
    private final ScoringParameters params;
    private final OpeningIntervalCalculator openingIntervalCalculator;
    private Activity firstActivity;
    private static final Logger log = Logger.getLogger(CharyparNagelActivityScoring.class);

    public CharyparNagelActivityScoring(ScoringParameters params) {
        this(params, new ActivityTypeOpeningIntervalCalculator(params));
    }

    public CharyparNagelActivityScoring(ScoringParameters params, OpeningIntervalCalculator openingIntervalCalculator) {
        this.params = params;
        this.currentActivityStartTime = 0.0;
        this.firstActivityEndTime = Double.NEGATIVE_INFINITY;
        this.score = 0.0;
        firstLastActOpeningTimesWarning = 0;
        this.openingIntervalCalculator = openingIntervalCalculator;
    }

    @Override
    public void finish() {
        if (this.firstActivity != null) {
            this.handleMorningActivity();
        }
    }

    @Override
    public double getScore() {
        return this.score;
    }

    protected double calcActScore(double arrivalTime, double departureTime, Activity act) {
        ActivityUtilityParameters actParams = this.params.utilParams.get(act.getType());
        if (actParams == null) {
            throw new IllegalArgumentException("acttype \"" + act.getType() + "\" is not known in utility parameters " + "(module name=\"planCalcScore\" in the config file).");
        }
        double tmpScore = 0.0;
        if (actParams.isScoreAtAll()) {
            double minimalDuration;
            double utilPerf;
            double latestStartTime;
            double[] openingInterval = this.openingIntervalCalculator.getOpeningInterval(act);
            double openingTime = openingInterval[0];
            double closingTime = openingInterval[1];
            double activityStart = arrivalTime;
            double activityEnd = departureTime;
            if (openingTime >= 0.0 && arrivalTime < openingTime) {
                activityStart = openingTime;
            }
            if (closingTime >= 0.0 && closingTime < departureTime) {
                activityEnd = closingTime;
            }
            if (openingTime >= 0.0 && closingTime >= 0.0 && (openingTime > departureTime || closingTime < arrivalTime)) {
                activityStart = departureTime;
                activityEnd = departureTime;
            }
            double duration = activityEnd - activityStart;
            if (arrivalTime < activityStart) {
                tmpScore += this.params.marginalUtilityOfWaiting_s * (activityStart - arrivalTime);
            }
            if ((latestStartTime = actParams.getLatestStartTime()) >= 0.0 && activityStart > latestStartTime) {
                tmpScore += this.params.marginalUtilityOfLateArrival_s * (activityStart - latestStartTime);
            }
            double typicalDuration = actParams.getTypicalDuration();
            if (this.params.usingOldScoringBelowZeroUtilityDuration) {
                if (duration > 0.0) {
                    utilPerf = this.params.marginalUtilityOfPerforming_s * typicalDuration * Math.log(duration / 3600.0 / actParams.getZeroUtilityDuration_h());
                    double utilWait = this.params.marginalUtilityOfWaiting_s * duration;
                    tmpScore += Math.max(0.0, Math.max(utilPerf, utilWait));
                } else {
                    tmpScore += 2.0 * this.params.marginalUtilityOfLateArrival_s * Math.abs(duration);
                }
            } else if (duration >= 3600.0 * actParams.getZeroUtilityDuration_h()) {
                utilPerf = this.params.marginalUtilityOfPerforming_s * typicalDuration * Math.log(duration / 3600.0 / actParams.getZeroUtilityDuration_h());
                tmpScore += utilPerf;
            } else {
                double slopeAtZeroUtility = this.params.marginalUtilityOfPerforming_s * typicalDuration / (3600.0 * actParams.getZeroUtilityDuration_h());
                if (slopeAtZeroUtility < 0.0) {
                    System.err.println("beta_perf: " + this.params.marginalUtilityOfPerforming_s);
                    System.err.println("typicalDuration: " + typicalDuration);
                    System.err.println("zero utl duration: " + actParams.getZeroUtilityDuration_h());
                    throw new RuntimeException("slope at zero utility < 0.; this should not happen ...");
                }
                double durationUnderrun = actParams.getZeroUtilityDuration_h() * 3600.0 - duration;
                if (durationUnderrun < 0.0) {
                    throw new RuntimeException("durationUnderrun < 0; this should not happen ...");
                }
                tmpScore -= slopeAtZeroUtility * durationUnderrun;
            }
            double earliestEndTime = actParams.getEarliestEndTime();
            if (earliestEndTime >= 0.0 && activityEnd < earliestEndTime) {
                tmpScore += this.params.marginalUtilityOfEarlyDeparture_s * (earliestEndTime - activityEnd);
            }
            if (activityEnd < departureTime) {
                tmpScore += this.params.marginalUtilityOfWaiting_s * (departureTime - activityEnd);
            }
            if ((minimalDuration = actParams.getMinimalDuration()) >= 0.0 && duration < minimalDuration) {
                tmpScore += this.params.marginalUtilityOfEarlyDeparture_s * (minimalDuration - duration);
            }
        }
        return tmpScore;
    }

    private void handleOvernightActivity(Activity lastActivity) {
        assert (this.firstActivity != null);
        assert (lastActivity != null);
        if (lastActivity.getType().equals(this.firstActivity.getType()) || this.firstActivity.getType().equals("not specified")) {
            double[] openInterval;
            if (firstLastActOpeningTimesWarning <= 10 && ((openInterval = this.openingIntervalCalculator.getOpeningInterval(lastActivity))[0] >= 0.0 || openInterval[1] >= 0.0)) {
                log.warn("There are opening or closing times defined for the first and last activity. The correctness of the scoring function can thus not be guaranteed.");
                log.warn("first activity: " + this.firstActivity);
                log.warn("last activity: " + lastActivity);
                if (firstLastActOpeningTimesWarning == 10) {
                    log.warn("Additional warnings of this type are suppressed.");
                }
                firstLastActOpeningTimesWarning = (short)(firstLastActOpeningTimesWarning + 1);
            }
            double calcActScore = this.calcActScore(this.currentActivityStartTime, this.firstActivityEndTime + 86400.0, lastActivity);
            this.score += calcActScore;
        } else if (this.params.scoreActs) {
            int last = 0;
            if (firstLastActWarning <= last) {
                log.warn("The first and the last activity do not have the same type. ");
                log.warn("Will score the first activity from midnight to its end, and the last activity from its start to midnight.");
                log.warn("Because of the nonlinear function, this is not the same as scoring from start to end.");
                log.warn("first activity: " + this.firstActivity);
                log.warn("last activity: " + lastActivity);
                log.warn("This may also happen when plans are not completed when the simulation ends.");
                if (firstLastActWarning == last) {
                    log.warn("Additional warnings of this type are suppressed.");
                }
                ++firstLastActWarning;
            }
            this.score += this.calcActScore(0.0, this.firstActivityEndTime, this.firstActivity);
            this.score += this.calcActScore(this.currentActivityStartTime, this.params.simulationPeriodInDays * 24.0 * 3600.0, lastActivity);
        }
    }

    private void handleMorningActivity() {
        assert (this.firstActivity != null);
        this.score += this.calcActScore(0.0, this.firstActivityEndTime, this.firstActivity);
    }

    @Override
    public void handleFirstActivity(Activity act) {
        assert (act != null);
        this.firstActivityEndTime = act.getEndTime();
        this.firstActivity = act;
    }

    @Override
    public void handleActivity(Activity act) {
        this.score += this.calcActScore(act.getStartTime(), act.getEndTime(), act);
    }

    @Override
    public void handleLastActivity(Activity act) {
        this.currentActivityStartTime = act.getStartTime();
        this.handleOvernightActivity(act);
        this.firstActivity = null;
    }
}

