/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.scoring.SumScoringFunction;
import org.matsim.core.scoring.functions.ModeUtilityParameters;
import org.matsim.core.scoring.functions.ScoringParameters;
import org.matsim.core.utils.misc.Time;

public class CharyparNagelLegScoring
implements SumScoringFunction.LegScoring,
SumScoringFunction.ArbitraryEventScoring {
    private static final Logger log = Logger.getLogger(CharyparNagelLegScoring.class);
    protected double score;
    protected final ScoringParameters params;
    protected Network network;
    private boolean nextEnterVehicleIsFirstOfTrip = true;
    private boolean nextStartPtLegIsFirstOfTrip = true;
    private boolean currentLegIsPtLeg = false;
    private double lastActivityEndTime = Time.getUndefinedTime();
    private final Set<String> ptModes;
    private Set<String> modesAlreadyConsideredForDailyConstants;
    private static int ccc = 0;

    public CharyparNagelLegScoring(ScoringParameters params, Network network, Set<String> ptModes) {
        this.params = params;
        this.network = network;
        this.ptModes = ptModes;
        this.modesAlreadyConsideredForDailyConstants = new HashSet<String>();
    }

    public CharyparNagelLegScoring(ScoringParameters params, Network network) {
        this(params, network, new HashSet<String>(Collections.singletonList("pt")));
    }

    @Override
    public void finish() {
    }

    @Override
    public double getScore() {
        return this.score;
    }

    protected double calcLegScore(double departureTime, double arrivalTime, Leg leg) {
        double tmpScore = 0.0;
        double travelTime = arrivalTime - departureTime;
        ModeUtilityParameters modeParams = this.params.modeParams.get(leg.getMode());
        if (modeParams == null) {
            if (leg.getMode().equals("transit_walk") || leg.getMode().equals("non_network_walk") || leg.getMode().equals("non_network_walk")) {
                modeParams = this.params.modeParams.get("walk");
            } else {
                throw new RuntimeException("just encountered mode for which no scoring parameters are defined: " + leg.getMode());
            }
        }
        tmpScore += travelTime * modeParams.marginalUtilityOfTraveling_s;
        if (modeParams.marginalUtilityOfDistance_m != 0.0 || modeParams.monetaryDistanceCostRate != 0.0) {
            Route route = leg.getRoute();
            double dist = route.getDistance();
            if (Double.isNaN(dist) && ccc < 10) {
                Logger.getLogger(this.getClass()).warn("distance is NaN. Will make score of this plan NaN. Possible reason: Simulation does not report a distance for this trip. Possible reason for that: mode is teleported and router does not write distance into plan.  Needs to be fixed or these plans will die out.");
                if (++ccc == 10) {
                    Logger.getLogger(this.getClass()).warn(" Future occurences of this logging statement are suppressed.");
                }
            }
            tmpScore += modeParams.marginalUtilityOfDistance_m * dist;
            tmpScore += modeParams.monetaryDistanceCostRate * this.params.marginalUtilityOfMoney * dist;
        }
        tmpScore += modeParams.constant;
        if (!this.modesAlreadyConsideredForDailyConstants.contains(leg.getMode())) {
            tmpScore += modeParams.dailyUtilityConstant + modeParams.dailyMoneyConstant * this.params.marginalUtilityOfMoney;
            this.modesAlreadyConsideredForDailyConstants.add(leg.getMode());
        }
        return tmpScore;
    }

    @Override
    public void handleEvent(Event event) {
        if (event instanceof ActivityEndEvent) {
            if (!"pt interaction".equals(((ActivityEndEvent)event).getActType())) {
                this.nextEnterVehicleIsFirstOfTrip = true;
                this.nextStartPtLegIsFirstOfTrip = true;
            }
            this.lastActivityEndTime = event.getTime();
        }
        if (event instanceof PersonEntersVehicleEvent && this.currentLegIsPtLeg) {
            if (!this.nextEnterVehicleIsFirstOfTrip) {
                this.score += this.params.utilityOfLineSwitch;
            }
            this.nextEnterVehicleIsFirstOfTrip = false;
            this.score += (event.getTime() - this.lastActivityEndTime) * (this.params.marginalUtilityOfWaitingPt_s - this.params.modeParams.get((Object)"pt").marginalUtilityOfTraveling_s);
        }
        if (event instanceof PersonDepartureEvent) {
            String mode = ((PersonDepartureEvent)event).getLegMode();
            this.currentLegIsPtLeg = this.ptModes.contains(mode);
            if (this.currentLegIsPtLeg) {
                if (!this.nextStartPtLegIsFirstOfTrip) {
                    this.score -= this.params.modeParams.get((Object)mode).constant;
                }
                this.nextStartPtLegIsFirstOfTrip = false;
            }
        }
    }

    @Override
    public void handleLeg(Leg leg) {
        Gbl.assertIf(!Time.isUndefinedTime(leg.getDepartureTime()));
        Gbl.assertIf(!Time.isUndefinedTime(leg.getTravelTime()));
        double legScore = this.calcLegScore(leg.getDepartureTime(), leg.getDepartureTime() + leg.getTravelTime(), leg);
        if (Double.isNaN(legScore)) {
            log.error("dpTime=" + leg.getDepartureTime() + "; ttime=" + leg.getTravelTime() + "; leg=" + leg);
            throw new RuntimeException("score is NaN");
        }
        this.score += legScore;
    }
}

