/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.scoring.ScoringFunction;
import org.matsim.core.scoring.ScoringFunctionFactory;
import org.matsim.core.scoring.SumScoringFunction;
import org.matsim.core.scoring.functions.CharyparNagelActivityScoring;
import org.matsim.core.scoring.functions.CharyparNagelAgentStuckScoring;
import org.matsim.core.scoring.functions.CharyparNagelLegScoring;
import org.matsim.core.scoring.functions.CharyparNagelMoneyScoring;
import org.matsim.core.scoring.functions.FacilityOpeningIntervalCalculator;
import org.matsim.core.scoring.functions.ScoringParameters;
import org.matsim.core.scoring.functions.ScoringParametersForPerson;
import org.matsim.core.scoring.functions.SubpopulationScoringParameters;

public final class CharyparNagelOpenTimesScoringFunctionFactory
implements ScoringFunctionFactory {
    private final ScoringParametersForPerson params;
    private final Scenario scenario;

    public CharyparNagelOpenTimesScoringFunctionFactory(ScoringParametersForPerson params, Scenario scenario) {
        this.params = params;
        this.scenario = scenario;
    }

    public CharyparNagelOpenTimesScoringFunctionFactory(Scenario scenario) {
        this.params = new SubpopulationScoringParameters(scenario);
        this.scenario = scenario;
    }

    @Override
    public ScoringFunction createNewScoringFunction(Person person) {
        ScoringParameters parameters = this.params.getScoringParameters(person);
        SumScoringFunction sumScoringFunction = new SumScoringFunction();
        sumScoringFunction.addScoringFunction(new CharyparNagelActivityScoring(parameters, new FacilityOpeningIntervalCalculator(this.scenario.getActivityFacilities())));
        sumScoringFunction.addScoringFunction(new CharyparNagelLegScoring(parameters, this.scenario.getNetwork(), this.scenario.getConfig().transit().getTransitModes()));
        sumScoringFunction.addScoringFunction(new CharyparNagelMoneyScoring(parameters));
        sumScoringFunction.addScoringFunction(new CharyparNagelAgentStuckScoring(parameters));
        return sumScoringFunction;
    }
}

