/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import java.util.Iterator;
import java.util.SortedSet;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.scoring.functions.OpeningIntervalCalculator;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.OpeningTime;

public final class FacilityOpeningIntervalCalculator
implements OpeningIntervalCalculator {
    private final ActivityFacilities facilities;

    public FacilityOpeningIntervalCalculator(ActivityFacilities facilities) {
        this.facilities = facilities;
    }

    @Override
    public double[] getOpeningInterval(Activity act) {
        double[] openInterval = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        boolean foundAct = false;
        ActivityFacility facility = this.facilities.getFacilities().get(act.getFacilityId());
        Iterator<String> facilityActTypeIterator = facility.getActivityOptions().keySet().iterator();
        String facilityActType = null;
        SortedSet<OpeningTime> opentimes = null;
        while (facilityActTypeIterator.hasNext() && !foundAct) {
            facilityActType = facilityActTypeIterator.next();
            if (!act.getType().equals(facilityActType)) continue;
            foundAct = true;
            opentimes = facility.getActivityOptions().get(facilityActType).getOpeningTimes();
            if (opentimes == null || opentimes.isEmpty()) continue;
            openInterval[0] = Double.MAX_VALUE;
            openInterval[1] = Double.MIN_VALUE;
            for (OpeningTime opentime : opentimes) {
                openInterval[0] = Math.min(openInterval[0], opentime.getStartTime());
                openInterval[1] = Math.max(openInterval[1], opentime.getEndTime());
            }
        }
        if (!foundAct) {
            throw new RuntimeException("No suitable facility activity type found. Aborting...");
        }
        return openInterval;
    }
}

