/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import java.util.Map;
import java.util.TreeMap;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.ScenarioConfigGroup;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.scoring.functions.ActivityUtilityParameters;
import org.matsim.core.scoring.functions.ModeUtilityParameters;

public class ScoringParameters
implements MatsimParameters {
    public final Map<String, ActivityUtilityParameters> utilParams;
    public final Map<String, ModeUtilityParameters> modeParams;
    public final double marginalUtilityOfWaiting_s;
    public final double marginalUtilityOfLateArrival_s;
    public final double marginalUtilityOfEarlyDeparture_s;
    public final double marginalUtilityOfWaitingPt_s;
    public final double marginalUtilityOfPerforming_s;
    public final double utilityOfLineSwitch;
    public final double marginalUtilityOfMoney;
    public final double abortedPlanScore;
    public final boolean scoreActs;
    public final boolean usingOldScoringBelowZeroUtilityDuration;
    public final double simulationPeriodInDays;

    private ScoringParameters(Map<String, ActivityUtilityParameters> utilParams, Map<String, ModeUtilityParameters> modeParams, double marginalUtilityOfWaiting_s, double marginalUtilityOfLateArrival_s, double marginalUtilityOfEarlyDeparture_s, double marginalUtilityOfWaitingPt_s, double marginalUtilityOfPerforming_s, double utilityOfLineSwitch, double marginalUtilityOfMoney, double abortedPlanScore, boolean scoreActs, boolean usingOldScoringBelowZeroUtilityDuration, double simulationPeriodInDays) {
        this.utilParams = utilParams;
        this.modeParams = modeParams;
        this.marginalUtilityOfWaiting_s = marginalUtilityOfWaiting_s;
        this.marginalUtilityOfLateArrival_s = marginalUtilityOfLateArrival_s;
        this.marginalUtilityOfEarlyDeparture_s = marginalUtilityOfEarlyDeparture_s;
        this.marginalUtilityOfWaitingPt_s = marginalUtilityOfWaitingPt_s;
        this.marginalUtilityOfPerforming_s = marginalUtilityOfPerforming_s;
        this.utilityOfLineSwitch = utilityOfLineSwitch;
        this.marginalUtilityOfMoney = marginalUtilityOfMoney;
        this.abortedPlanScore = abortedPlanScore;
        this.scoreActs = scoreActs;
        this.usingOldScoringBelowZeroUtilityDuration = usingOldScoringBelowZeroUtilityDuration;
        this.simulationPeriodInDays = simulationPeriodInDays;
    }

    public static final class Builder {
        private final Map<String, ActivityUtilityParameters.Builder> utilParams;
        private final Map<String, ModeUtilityParameters.Builder> modeParams;
        private double marginalUtilityOfWaiting_s;
        private double marginalUtilityOfLateArrival_s;
        private double marginalUtilityOfEarlyDeparture_s;
        private double marginalUtilityOfWaitingPt_s;
        private double marginalUtilityOfPerforming_s;
        private double utilityOfLineSwitch;
        private double marginalUtilityOfMoney;
        private double abortedPlanScore;
        private boolean scoreActs;
        private boolean usingOldScoringBelowZeroUtilityDuration;
        private double simulationPeriodInDays = 1.0;

        public Builder(Scenario scenario, Person person) {
            this(scenario.getConfig().planCalcScore(), scenario.getConfig().planCalcScore().getScoringParameters((String)PopulationUtils.getPersonAttribute(person, scenario.getConfig().plans().getSubpopulationAttributeName())), scenario.getConfig().scenario());
        }

        public Builder(PlanCalcScoreConfigGroup configGroup, PlanCalcScoreConfigGroup.ScoringParameterSet scoringParameterSet, ScenarioConfigGroup scenarioConfig) {
            this.simulationPeriodInDays = scenarioConfig.getSimulationPeriodInDays();
            this.usingOldScoringBelowZeroUtilityDuration = configGroup.isUsingOldScoringBelowZeroUtilityDuration();
            this.marginalUtilityOfWaiting_s = scoringParameterSet.getMarginalUtlOfWaiting_utils_hr() / 3600.0;
            this.marginalUtilityOfLateArrival_s = scoringParameterSet.getLateArrival_utils_hr() / 3600.0;
            this.marginalUtilityOfEarlyDeparture_s = scoringParameterSet.getEarlyDeparture_utils_hr() / 3600.0;
            this.marginalUtilityOfWaitingPt_s = scoringParameterSet.getMarginalUtlOfWaitingPt_utils_hr() / 3600.0;
            this.marginalUtilityOfPerforming_s = scoringParameterSet.getPerforming_utils_hr() / 3600.0;
            this.utilityOfLineSwitch = scoringParameterSet.getUtilityOfLineSwitch();
            this.marginalUtilityOfMoney = scoringParameterSet.getMarginalUtilityOfMoney();
            this.scoreActs = this.marginalUtilityOfPerforming_s != 0.0 || this.marginalUtilityOfWaiting_s != 0.0 || this.marginalUtilityOfLateArrival_s != 0.0 || this.marginalUtilityOfEarlyDeparture_s != 0.0;
            this.utilParams = new TreeMap<String, ActivityUtilityParameters.Builder>();
            for (PlanCalcScoreConfigGroup.ActivityParams params : scoringParameterSet.getActivityParams()) {
                ActivityUtilityParameters.Builder factory = new ActivityUtilityParameters.Builder(params);
                this.utilParams.put(params.getActivityType(), factory);
            }
            this.modeParams = new TreeMap<String, ModeUtilityParameters.Builder>();
            Map<String, PlanCalcScoreConfigGroup.ModeParams> modes = scoringParameterSet.getModes();
            double worstMarginalUtilityOfTraveling_s = 0.0;
            for (Map.Entry<String, PlanCalcScoreConfigGroup.ModeParams> mode : modes.entrySet()) {
                String modeName = mode.getKey();
                PlanCalcScoreConfigGroup.ModeParams params = mode.getValue();
                worstMarginalUtilityOfTraveling_s = Math.min(worstMarginalUtilityOfTraveling_s, params.getMarginalUtilityOfTraveling() / 3600.0);
                this.modeParams.put(modeName, new ModeUtilityParameters.Builder(params));
            }
            this.abortedPlanScore = Math.min(Math.min(this.marginalUtilityOfLateArrival_s, this.marginalUtilityOfEarlyDeparture_s), Math.min(worstMarginalUtilityOfTraveling_s - this.marginalUtilityOfPerforming_s, this.marginalUtilityOfWaiting_s - this.marginalUtilityOfPerforming_s)) * 3600.0 * 24.0;
        }

        public Builder setActivityParameters(String activityType, ActivityUtilityParameters.Builder params) {
            this.utilParams.put(activityType, params);
            return this;
        }

        public ActivityUtilityParameters.Builder getActivityParameters(String activityType) {
            return this.utilParams.get(activityType);
        }

        public Builder setModeParameters(String mode, ModeUtilityParameters.Builder params) {
            this.modeParams.put(mode, params);
            return this;
        }

        public ModeUtilityParameters.Builder getModeParameters(String mode) {
            return this.modeParams.get(mode);
        }

        public Builder setMarginalUtilityOfWaiting_s(double marginalUtilityOfWaiting_s) {
            this.marginalUtilityOfWaiting_s = marginalUtilityOfWaiting_s;
            return this;
        }

        public Builder setMarginalUtilityOfLateArrival_s(double marginalUtilityOfLateArrival_s) {
            this.marginalUtilityOfLateArrival_s = marginalUtilityOfLateArrival_s;
            return this;
        }

        public Builder setMarginalUtilityOfEarlyDeparture_s(double marginalUtilityOfEarlyDeparture_s) {
            this.marginalUtilityOfEarlyDeparture_s = marginalUtilityOfEarlyDeparture_s;
            return this;
        }

        public Builder setMarginalUtilityOfWaitingPt_s(double marginalUtilityOfWaitingPt_s) {
            this.marginalUtilityOfWaitingPt_s = marginalUtilityOfWaitingPt_s;
            return this;
        }

        public Builder setMarginalUtilityOfPerforming_s(double marginalUtilityOfPerforming_s) {
            this.marginalUtilityOfPerforming_s = marginalUtilityOfPerforming_s;
            return this;
        }

        public Builder setUtilityOfLineSwitch(double utilityOfLineSwitch) {
            this.utilityOfLineSwitch = utilityOfLineSwitch;
            return this;
        }

        public Builder setMarginalUtilityOfMoney(double marginalUtilityOfMoney) {
            this.marginalUtilityOfMoney = marginalUtilityOfMoney;
            return this;
        }

        public Builder setAbortedPlanScore(double abortedPlanScore) {
            this.abortedPlanScore = abortedPlanScore;
            return this;
        }

        public Builder setScoreActs(boolean scoreActs) {
            this.scoreActs = scoreActs;
            return this;
        }

        public Builder setUsingOldScoringBelowZeroUtilityDuration(boolean usingOldScoringBelowZeroUtilityDuration) {
            this.usingOldScoringBelowZeroUtilityDuration = usingOldScoringBelowZeroUtilityDuration;
            return this;
        }

        public ScoringParameters build() {
            TreeMap<String, ModeUtilityParameters> modes = new TreeMap<String, ModeUtilityParameters>();
            for (Map.Entry<String, ModeUtilityParameters.Builder> e : this.modeParams.entrySet()) {
                modes.put(e.getKey(), e.getValue().build());
            }
            TreeMap<String, ActivityUtilityParameters> acts = new TreeMap<String, ActivityUtilityParameters>();
            for (Map.Entry<String, ActivityUtilityParameters.Builder> e : this.utilParams.entrySet()) {
                acts.put(e.getKey(), e.getValue().build());
            }
            return new ScoringParameters(acts, modes, this.marginalUtilityOfWaiting_s, this.marginalUtilityOfLateArrival_s, this.marginalUtilityOfEarlyDeparture_s, this.marginalUtilityOfWaitingPt_s, this.marginalUtilityOfPerforming_s, this.utilityOfLineSwitch, this.marginalUtilityOfMoney, this.abortedPlanScore, this.scoreActs, this.usingOldScoringBelowZeroUtilityDuration, this.simulationPeriodInDays);
        }
    }
}

