/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.scoring.functions;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.ScenarioConfigGroup;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.scoring.functions.ActivityUtilityParameters;
import org.matsim.core.scoring.functions.ScoringParameters;
import org.matsim.core.scoring.functions.ScoringParametersForPerson;
import org.matsim.pt.config.TransitConfigGroup;

public class SubpopulationScoringParameters
implements ScoringParametersForPerson {
    private final PlanCalcScoreConfigGroup config;
    private final ScenarioConfigGroup scConfig;
    private final TransitConfigGroup transitConfigGroup;
    private final String subpopulationAttributeName;
    private final Map<String, ScoringParameters> params = new HashMap<String, ScoringParameters>();
    private final Population population;

    @Inject
    SubpopulationScoringParameters(PlansConfigGroup plansConfigGroup, PlanCalcScoreConfigGroup planCalcScoreConfigGroup, ScenarioConfigGroup scenarioConfigGroup, Population population, TransitConfigGroup transitConfigGroup) {
        this.config = planCalcScoreConfigGroup;
        this.scConfig = scenarioConfigGroup;
        this.transitConfigGroup = transitConfigGroup;
        this.subpopulationAttributeName = plansConfigGroup.getSubpopulationAttributeName();
        this.population = population;
    }

    public SubpopulationScoringParameters(Scenario scenario) {
        this(scenario.getConfig().plans(), scenario.getConfig().planCalcScore(), scenario.getConfig().scenario(), scenario.getPopulation(), scenario.getConfig().transit());
    }

    @Override
    public ScoringParameters getScoringParameters(Person person) {
        String subpopulation = (String)PopulationUtils.getPersonAttribute(person, this.subpopulationAttributeName);
        if (!this.params.containsKey(subpopulation)) {
            ScoringParameters.Builder builder = new ScoringParameters.Builder(this.config, this.config.getScoringParameters(subpopulation), this.scConfig);
            if (this.transitConfigGroup.isUseTransit()) {
                PlanCalcScoreConfigGroup.ActivityParams transitActivityParams = new PlanCalcScoreConfigGroup.ActivityParams("pt interaction");
                transitActivityParams.setTypicalDuration(120.0);
                transitActivityParams.setOpeningTime(0.0);
                transitActivityParams.setClosingTime(0.0);
                ActivityUtilityParameters.Builder modeParamsBuilder = new ActivityUtilityParameters.Builder(transitActivityParams);
                modeParamsBuilder.setScoreAtAll(false);
                builder.setActivityParameters("pt interaction", modeParamsBuilder);
            }
            this.params.put(subpopulation, builder.build());
        }
        return this.params.get(subpopulation);
    }
}

