/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.priorityqueue.HasIndex;
import org.matsim.core.trafficmonitoring.DataContainerProvider;
import org.matsim.core.trafficmonitoring.MapBasedDataContainerProvider;
import org.matsim.core.trafficmonitoring.TravelTimeData;
import org.matsim.core.trafficmonitoring.TravelTimeDataFactory;

class ArrayBasedDataContainerProvider
implements DataContainerProvider {
    private final TravelTimeData[] arrayLinkData;
    private final DataContainerProvider delegate;

    public ArrayBasedDataContainerProvider(Map<Id<Link>, TravelTimeData> linkData, TravelTimeDataFactory ttDataFactory, Network network) {
        this.arrayLinkData = new TravelTimeData[network.getLinks().size()];
        this.delegate = new MapBasedDataContainerProvider(linkData, ttDataFactory);
    }

    @Override
    public TravelTimeData getTravelTimeData(Id<Link> linkId, boolean createIfMissing) {
        return this.delegate.getTravelTimeData(linkId, createIfMissing);
    }

    @Override
    public TravelTimeData getTravelTimeData(Link link, boolean createIfMissing) {
        if (link instanceof HasIndex) {
            int index = ((HasIndex)((Object)link)).getArrayIndex();
            TravelTimeData data = this.arrayLinkData[index];
            if (data == null) {
                this.arrayLinkData[index] = data = this.delegate.getTravelTimeData(link, createIfMissing);
            }
            return data;
        }
        return this.delegate.getTravelTimeData(link, createIfMissing);
    }
}

