/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.trafficmonitoring.DepartureEvent;

class DepartureDelayAverageCalculator
implements PersonDepartureEventHandler,
LinkLeaveEventHandler,
VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler {
    private Network network;
    private int timeBinSize;
    private HashMap<DepartureEvent, Double> departureEventsTimes = new HashMap();
    private final HashMap<Id<Link>, DepartureDelayData> linkData;
    private Vehicle2DriverEventHandler delegate = new Vehicle2DriverEventHandler();
    private static final Logger log = Logger.getLogger(DepartureDelayAverageCalculator.class);

    public DepartureDelayAverageCalculator(Network network, int timeBinSize) {
        this.network = network;
        this.timeBinSize = timeBinSize;
        this.linkData = new HashMap(this.network.getLinks().size());
        this.resetDepartureDelays();
    }

    public double getLinkDepartureDelay(Id<Link> linkId, double departureTime) {
        DepartureDelayData ddd = this.getDepartureDelayRole(linkId);
        if (ddd == null) {
            return 0.0;
        }
        return ddd.getDepartureDelay(departureTime);
    }

    private DepartureDelayData getDepartureDelayRole(Id<Link> linkId) {
        return this.linkData.get(linkId);
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        DepartureEvent depEvent = new DepartureEvent(event.getPersonId());
        this.departureEventsTimes.put(depEvent, event.getTime());
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        DepartureEvent removeMe = new DepartureEvent(this.delegate.getDriverOfVehicle(event.getVehicleId()));
        Double departureTime = this.departureEventsTimes.remove(removeMe);
        if (departureTime != null) {
            double departureDelay = event.getTime() - (double)departureTime.intValue();
            if (departureDelay < 0.0) {
                throw new RuntimeException("departureDelay cannot be < 0.");
            }
            Id<Link> linkId = event.getLinkId();
            DepartureDelayData ddd = this.getDepartureDelayRole(linkId);
            if (ddd == null) {
                ddd = new DepartureDelayData();
                this.linkData.put(linkId, ddd);
            }
            ddd.addDepartureDelay(departureTime, departureDelay);
        }
    }

    public void resetDepartureDelays() {
        this.linkData.clear();
        this.departureEventsTimes.clear();
    }

    @Override
    public void reset(int iteration) {
        this.resetDepartureDelays();
        this.delegate.reset(iteration);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.delegate.handleEvent(event);
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.delegate.handleEvent(event);
    }

    class DepartureDelayData {
        private double[] timeSum = null;
        private int[] timeCnt = null;

        private DepartureDelayData() {
            this.resetDepartureDelays();
        }

        private int getTimeSlotIndex(double time) {
            int slice = (int)(time / (double)DepartureDelayAverageCalculator.this.timeBinSize);
            if (slice >= this.timeSum.length) {
                slice = this.timeSum.length - 1;
            }
            return slice;
        }

        public void addDepartureDelay(double departureTime, double departureDelay) {
            int index;
            int n = index = this.getTimeSlotIndex(departureTime);
            this.timeSum[n] = this.timeSum[n] + departureDelay;
            int n2 = index;
            this.timeCnt[n2] = this.timeCnt[n2] + 1;
        }

        public double getDepartureDelay(double time) {
            double departureDelay = 0.0;
            try {
                int cnt;
                int index = this.getTimeSlotIndex(time);
                double sum = 0.0;
                sum = this.timeSum[index];
                if (sum > 0.0 && (cnt = this.timeCnt[index]) > 0) {
                    departureDelay = sum / (double)cnt;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.warn("A departure delay for an invalid value of time was requested. Returning departureDelay = 0.0. time = " + Double.toString(time));
            }
            return departureDelay;
        }

        public void resetDepartureDelays() {
            int nofSlots = 97200 / DepartureDelayAverageCalculator.this.timeBinSize;
            this.timeSum = new double[nofSlots];
            this.timeCnt = new int[nofSlots];
        }
    }
}

