/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import org.matsim.core.trafficmonitoring.TimeSlotComputation;
import org.matsim.core.trafficmonitoring.TravelTimeData;
import org.matsim.core.trafficmonitoring.TravelTimeGetter;

class LinearInterpolatingTravelTimeGetter
implements TravelTimeGetter {
    private final TimeSlotComputation travelTimeAggregator;
    private final int numSlots;
    private final int travelTimeBinSize;
    private final double halfBinSize;

    public LinearInterpolatingTravelTimeGetter(int numSlots, int travelTimeBinSize, TimeSlotComputation aggregator) {
        this.numSlots = numSlots;
        this.travelTimeBinSize = travelTimeBinSize;
        this.halfBinSize = (double)travelTimeBinSize / 2.0;
        this.travelTimeAggregator = aggregator;
    }

    @Override
    public double getTravelTime(TravelTimeData travelTimeData, double time) {
        int secondSlot;
        int firstSlot;
        int timeSlot = this.travelTimeAggregator.getTimeSlotIndex(time);
        if (time <= this.halfBinSize) {
            return travelTimeData.getTravelTime(timeSlot, time);
        }
        if (time >= (double)(this.numSlots * this.travelTimeBinSize) - this.halfBinSize) {
            return travelTimeData.getTravelTime(timeSlot, time);
        }
        if ((double)(timeSlot * this.travelTimeBinSize) + this.halfBinSize > time) {
            firstSlot = timeSlot - 1;
            secondSlot = timeSlot;
        } else {
            firstSlot = timeSlot;
            secondSlot = timeSlot + 1;
        }
        double firstTravelTime = travelTimeData.getTravelTime(firstSlot, time);
        double secondTravelTime = travelTimeData.getTravelTime(secondSlot, time);
        double dx = time - ((double)(firstSlot * this.travelTimeBinSize) + this.halfBinSize);
        double dy = (secondTravelTime - firstTravelTime) * dx / (double)this.travelTimeBinSize;
        return firstTravelTime + dy;
    }
}

