/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.trafficmonitoring.DataContainerProvider;
import org.matsim.core.trafficmonitoring.TravelTimeData;
import org.matsim.core.trafficmonitoring.TravelTimeDataFactory;

class MapBasedDataContainerProvider
implements DataContainerProvider {
    private final Map<Id<Link>, TravelTimeData> linkData;
    private final TravelTimeDataFactory ttDataFactory;

    public MapBasedDataContainerProvider(Map<Id<Link>, TravelTimeData> linkData, TravelTimeDataFactory ttDataFactory) {
        this.linkData = linkData;
        this.ttDataFactory = ttDataFactory;
    }

    @Override
    public TravelTimeData getTravelTimeData(Id<Link> linkId, boolean createIfMissing) {
        TravelTimeData data = this.linkData.get(linkId);
        if (null == data && createIfMissing) {
            data = this.ttDataFactory.createTravelTimeData(linkId);
            this.linkData.put(linkId, data);
        }
        return data;
    }

    @Override
    public TravelTimeData getTravelTimeData(Link link, boolean createIfMissing) {
        return this.getTravelTimeData(link.getId(), createIfMissing);
    }
}

