/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.VehicleAbortsEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleAbortsEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.config.groups.TravelTimeCalculatorConfigGroup;
import org.matsim.core.router.util.LinkToLinkTravelTime;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.trafficmonitoring.ArrayBasedDataContainerProvider;
import org.matsim.core.trafficmonitoring.AveragingTravelTimeGetter;
import org.matsim.core.trafficmonitoring.DataContainerProvider;
import org.matsim.core.trafficmonitoring.LinearInterpolatingTravelTimeGetter;
import org.matsim.core.trafficmonitoring.TimeBinUtils;
import org.matsim.core.trafficmonitoring.TimeSlotComputation;
import org.matsim.core.trafficmonitoring.TravelTimeData;
import org.matsim.core.trafficmonitoring.TravelTimeDataArrayFactory;
import org.matsim.core.trafficmonitoring.TravelTimeDataFactory;
import org.matsim.core.trafficmonitoring.TravelTimeDataHashMapFactory;
import org.matsim.core.trafficmonitoring.TravelTimeGetter;
import org.matsim.core.utils.collections.CollectionUtils;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleType;

public final class TravelTimeCalculator
implements LinkEnterEventHandler,
LinkLeaveEventHandler,
VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler,
VehicleArrivesAtFacilityEventHandler,
VehicleAbortsEventHandler {
    private static final Logger log = Logger.getLogger(TravelTimeCalculator.class);
    private static final String ERROR_STUCK_AND_LINKTOLINK = "Using the stuck feature with turning move travel times is not available. As the next link of a stuckedagent is not known the turning move travel time cannot be calculated!";
    private final int timeSlice;
    private final int numSlots;
    TimeSlotComputation aggregator;
    private Map<Id<Link>, TravelTimeData> linkData;
    private Map<Tuple<Id<Link>, Id<Link>>, TravelTimeData> linkToLinkData;
    private final DataContainerProvider dataContainerProvider;
    private final Map<Id<Vehicle>, LinkEnterEvent> linkEnterEvents;
    private final Set<Id<Vehicle>> vehiclesToIgnore;
    private final Set<String> analyzedModes;
    private final boolean filterAnalyzedModes;
    private final boolean calculateLinkTravelTimes;
    private final boolean calculateLinkToLinkTravelTimes;
    private TravelTimeDataFactory ttDataFactory = null;
    @Inject
    private QSimConfigGroup qsimConfig;
    TravelTimeGetter travelTimeGetter;
    private static int cnt = 0;

    @Deprecated
    public static TravelTimeCalculator create(Network network, TravelTimeCalculatorConfigGroup group) {
        TravelTimeCalculator calculator = new TravelTimeCalculator(network, group);
        TravelTimeCalculator.configure(calculator, group, network);
        return calculator;
    }

    private static TravelTimeCalculator configure(TravelTimeCalculator calculator, TravelTimeCalculatorConfigGroup config, Network network) {
        switch (config.getTravelTimeCalculatorType()) {
            case TravelTimeCalculatorArray: {
                calculator.ttDataFactory = new TravelTimeDataArrayFactory(network, calculator.numSlots);
                break;
            }
            case TravelTimeCalculatorHashMap: {
                calculator.ttDataFactory = new TravelTimeDataHashMapFactory(network);
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)config.getTravelTimeCalculatorType()) + " is unknown!");
            }
        }
        switch (config.getTravelTimeGetterType()) {
            case "average": {
                calculator.travelTimeGetter = new AveragingTravelTimeGetter(calculator.aggregator);
                break;
            }
            case "linearinterpolation": {
                calculator.travelTimeGetter = new LinearInterpolatingTravelTimeGetter(calculator.numSlots, calculator.timeSlice, calculator.aggregator);
                break;
            }
            default: {
                throw new RuntimeException(config.getTravelTimeGetterType() + " is unknown!");
            }
        }
        return calculator;
    }

    @Deprecated
    @Inject
    TravelTimeCalculator(TravelTimeCalculatorConfigGroup ttconfigGroup, EventsManager eventsManager, Network network) {
        this(network, ttconfigGroup.getTraveltimeBinSize(), ttconfigGroup.getMaxTime(), ttconfigGroup.isCalculateLinkTravelTimes(), ttconfigGroup.isCalculateLinkToLinkTravelTimes(), ttconfigGroup.isFilterModes(), CollectionUtils.stringToSet(ttconfigGroup.getAnalyzedModesAsString()));
        eventsManager.addHandler(this);
        TravelTimeCalculator.configure(this, ttconfigGroup, network);
    }

    @Deprecated
    public TravelTimeCalculator(Network network, TravelTimeCalculatorConfigGroup ttconfigGroup) {
        this(network, ttconfigGroup.getTraveltimeBinSize(), ttconfigGroup.getMaxTime(), ttconfigGroup);
    }

    @Deprecated
    public TravelTimeCalculator(Network network, int timeslice, int maxTime, TravelTimeCalculatorConfigGroup ttconfigGroup) {
        this(network, timeslice, maxTime, ttconfigGroup.isCalculateLinkTravelTimes(), ttconfigGroup.isCalculateLinkToLinkTravelTimes(), ttconfigGroup.isFilterModes(), CollectionUtils.stringToSet(ttconfigGroup.getAnalyzedModesAsString()));
    }

    private TravelTimeCalculator(Network network, int timeslice, int maxTime, boolean calculateLinkTravelTimes, boolean calculateLinkToLinkTravelTimes, boolean filterModes, Set<String> analyzedModes) {
        this.calculateLinkTravelTimes = calculateLinkTravelTimes;
        this.calculateLinkToLinkTravelTimes = calculateLinkToLinkTravelTimes;
        this.filterAnalyzedModes = filterModes;
        this.analyzedModes = analyzedModes;
        this.timeSlice = timeslice;
        this.numSlots = TimeBinUtils.getTimeBinCount(maxTime, timeslice);
        this.aggregator = new TimeSlotComputation(this.numSlots, this.timeSlice);
        this.travelTimeGetter = new AveragingTravelTimeGetter(this.aggregator);
        this.ttDataFactory = new TravelTimeDataArrayFactory(network, this.numSlots);
        if (this.calculateLinkTravelTimes) {
            this.linkData = new ConcurrentHashMap<Id<Link>, TravelTimeData>((int)((double)network.getLinks().size() * 1.4));
            this.dataContainerProvider = new ArrayBasedDataContainerProvider(this.linkData, this.ttDataFactory, network);
        } else {
            this.dataContainerProvider = null;
        }
        if (this.calculateLinkToLinkTravelTimes) {
            this.linkToLinkData = new ConcurrentHashMap<Tuple<Id<Link>, Id<Link>>, TravelTimeData>((int)((double)network.getLinks().size() * 1.4 * 2.0));
        }
        this.linkEnterEvents = new ConcurrentHashMap<Id<Vehicle>, LinkEnterEvent>();
        this.vehiclesToIgnore = new HashSet<Id<Vehicle>>();
        this.reset(0);
    }

    @Override
    public void handleEvent(LinkEnterEvent e) {
        if (this.filterAnalyzedModes && this.vehiclesToIgnore.contains(e.getVehicleId())) {
            return;
        }
        LinkEnterEvent oldEvent = this.linkEnterEvents.remove(e.getVehicleId());
        if (oldEvent != null && this.calculateLinkToLinkTravelTimes) {
            Tuple<Id<Link>, Id<Link>> fromToLink = new Tuple<Id<Link>, Id<Link>>(oldEvent.getLinkId(), e.getLinkId());
            TravelTimeData data = this.getLinkToLinkTravelTimeData(fromToLink);
            double enterTime = oldEvent.getTime();
            int timeSlot = this.aggregator.getTimeSlotIndex(enterTime);
            data.addTravelTime(timeSlot, e.getTime() - enterTime);
            data.setNeedsConsolidation(true);
        }
        this.linkEnterEvents.put(e.getVehicleId(), e);
    }

    @Override
    public void handleEvent(LinkLeaveEvent e) {
        LinkEnterEvent oldEvent;
        if (this.calculateLinkTravelTimes && (oldEvent = this.linkEnterEvents.get(e.getVehicleId())) != null) {
            TravelTimeData data = this.dataContainerProvider.getTravelTimeData(e.getLinkId(), true);
            double enterTime = oldEvent.getTime();
            int timeSlot = this.aggregator.getTimeSlotIndex(enterTime);
            data.addTravelTime(timeSlot, e.getTime() - enterTime);
            data.setNeedsConsolidation(true);
        }
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        if (this.filterAnalyzedModes && !this.analyzedModes.contains(event.getNetworkMode())) {
            this.vehiclesToIgnore.add(event.getVehicleId());
        }
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.linkEnterEvents.remove(event.getVehicleId());
        if (this.filterAnalyzedModes) {
            this.vehiclesToIgnore.remove(event.getVehicleId());
        }
    }

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        this.linkEnterEvents.remove(event.getVehicleId());
    }

    @Override
    public void handleEvent(VehicleAbortsEvent event) {
        LinkEnterEvent e = this.linkEnterEvents.remove(event.getVehicleId());
        if (e != null) {
            TravelTimeData data = this.dataContainerProvider.getTravelTimeData(e.getLinkId(), true);
            data.setNeedsConsolidation(true);
            if (this.calculateLinkToLinkTravelTimes && event.getTime() < this.qsimConfig.getEndTime()) {
                log.error(ERROR_STUCK_AND_LINKTOLINK);
                throw new IllegalStateException(ERROR_STUCK_AND_LINKTOLINK);
            }
        }
        if (this.filterAnalyzedModes) {
            this.vehiclesToIgnore.remove(event.getVehicleId());
        }
    }

    private TravelTimeData getLinkToLinkTravelTimeData(Tuple<Id<Link>, Id<Link>> fromLinkToLink) {
        TravelTimeData data = this.linkToLinkData.get(fromLinkToLink);
        if (null == data) {
            data = this.ttDataFactory.createTravelTimeData(fromLinkToLink.getFirst());
            this.linkToLinkData.put(fromLinkToLink, data);
        }
        return data;
    }

    private double getLinkTravelTime(Link link, double time) {
        if (this.calculateLinkTravelTimes) {
            TravelTimeData data = this.dataContainerProvider.getTravelTimeData(link, true);
            if (data.isNeedingConsolidation()) {
                this.consolidateData(data);
            }
            return this.travelTimeGetter.getTravelTime(data, time);
        }
        throw new IllegalStateException("No link travel time is available if calculation is switched off by config option!");
    }

    private double getLinkToLinkTravelTime(Id<Link> fromLinkId, Id<Link> toLinkId, double time) {
        if (!this.calculateLinkToLinkTravelTimes) {
            throw new IllegalStateException("No link to link travel time is available if calculation is switched off by config option!");
        }
        TravelTimeData data = this.getLinkToLinkTravelTimeData(new Tuple<Id<Link>, Id<Link>>(fromLinkId, toLinkId));
        if (data.isNeedingConsolidation()) {
            this.consolidateData(data);
        }
        return this.travelTimeGetter.getTravelTime(data, time);
    }

    @Override
    public void reset(int iteration) {
        if (this.calculateLinkTravelTimes) {
            for (TravelTimeData data : this.linkData.values()) {
                data.resetTravelTimes();
                data.setNeedsConsolidation(false);
            }
        }
        if (this.calculateLinkToLinkTravelTimes) {
            for (TravelTimeData data : this.linkToLinkData.values()) {
                data.resetTravelTimes();
                data.setNeedsConsolidation(false);
            }
        }
        this.linkEnterEvents.clear();
        this.vehiclesToIgnore.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consolidateData(TravelTimeData data) {
        TravelTimeData travelTimeData = data;
        synchronized (travelTimeData) {
            if (data.isNeedingConsolidation()) {
                double prevTravelTime = data.getTravelTime(0, 0.0);
                for (int i = 1; i < this.numSlots; ++i) {
                    double minTravelTime;
                    double travelTime = data.getTravelTime(i, i * this.timeSlice);
                    if (travelTime < (minTravelTime = prevTravelTime - (double)this.timeSlice)) {
                        data.setTravelTime(i, minTravelTime);
                    }
                    prevTravelTime = data.getTravelTime(i, i * this.timeSlice);
                }
                data.setNeedsConsolidation(false);
            }
        }
    }

    public TravelTime getLinkTravelTimes() {
        return new TravelTime(){

            @Override
            public double getLinkTravelTime(Link link, double time, Person person, Vehicle vehicle) {
                double linkTtimeFromVehicle = 0.0;
                if (vehicle != null) {
                    VehicleType vehicleType = vehicle.getType();
                    if (vehicleType == null) {
                        if (cnt < 1) {
                            cnt++;
                            log.warn("encountered vehicle where vehicle.getType() returns null.  That should be repaired (whereever it comes from).");
                            log.warn(" This message given only once.");
                        }
                    } else {
                        linkTtimeFromVehicle = link.getLength() / vehicleType.getMaximumVelocity();
                    }
                }
                double linkTTimeFromObservation = TravelTimeCalculator.this.getLinkTravelTime(link, time);
                return Math.max(linkTtimeFromVehicle, linkTTimeFromObservation);
            }
        };
    }

    public LinkToLinkTravelTime getLinkToLinkTravelTimes() {
        return new LinkToLinkTravelTime(){

            @Override
            public double getLinkToLinkTravelTime(Link fromLink, Link toLink, double time) {
                return TravelTimeCalculator.this.getLinkToLinkTravelTime(fromLink.getId(), toLink.getId(), time);
            }
        };
    }

    @Deprecated
    public void setTtDataFactory(TravelTimeDataFactory ttDataFactory) {
        this.ttDataFactory = ttDataFactory;
    }

    public static final class Builder {
        private final Network network;
        private int timeslice = 900;
        private int maxTime = 129600;
        private boolean calculateLinkTravelTimes = true;
        private boolean calculateLinkToLinkTravelTimes = false;
        private boolean filterModes = false;
        private Set<String> analyzedModes = null;
        private TravelTimeCalculatorConfigGroup ttcConfig;
        private boolean toBeConfigured = false;

        public Builder(Network network) {
            this.network = network;
        }

        public void setTimeslice(int timeslice) {
            this.timeslice = timeslice;
        }

        public void setMaxTime(int maxTime) {
            this.maxTime = maxTime;
        }

        public void setCalculateLinkTravelTimes(boolean calculateLinkTravelTimes) {
            this.calculateLinkTravelTimes = calculateLinkTravelTimes;
        }

        public void setCalculateLinkToLinkTravelTimes(boolean calculateLinkToLinkTravelTimes) {
            this.calculateLinkToLinkTravelTimes = calculateLinkToLinkTravelTimes;
        }

        public void setFilterModes(boolean filterModes) {
            this.filterModes = filterModes;
        }

        public void setAnalyzedModes(Set<String> analyzedModes) {
            this.analyzedModes = analyzedModes;
        }

        public void configure(TravelTimeCalculatorConfigGroup ttcConfig) {
            this.ttcConfig = ttcConfig;
            this.toBeConfigured = true;
        }

        public TravelTimeCalculator build() {
            TravelTimeCalculator abc = new TravelTimeCalculator(this.network, this.timeslice, this.maxTime, this.calculateLinkTravelTimes, this.calculateLinkToLinkTravelTimes, this.filterModes, this.analyzedModes);
            if (this.toBeConfigured) {
                TravelTimeCalculator.configure(abc, this.ttcConfig, this.network);
            }
            return abc;
        }
    }
}

