/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.TravelTimeCalculatorConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.router.util.LinkToLinkTravelTime;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.trafficmonitoring.TravelTimeCalculator;
import org.matsim.core.utils.collections.CollectionUtils;

public class TravelTimeCalculatorModule
extends AbstractModule {
    @Override
    public void install() {
        if (this.getConfig().travelTimeCalculator().getSeparateModes()) {
            if (this.getConfig().travelTimeCalculator().isCalculateLinkToLinkTravelTimes()) {
                throw new RuntimeException("separate modes together with link2link routing currently not implemented. doesn't look difficult, but I cannot say if it would be picked up correctly by downstream modules.  kai, nov'16");
            }
            for (final String mode : this.getConfig().plansCalcRoute().getNetworkModes()) {
                this.bind(TravelTimeCalculator.class).annotatedWith(Names.named(mode)).toProvider(new SingleModeTravelTimeCalculatorProvider(mode)).in(Singleton.class);
                this.addTravelTimeBinding(mode).toProvider(new Provider<TravelTime>(){
                    @Inject
                    Injector injector;

                    @Override
                    public TravelTime get() {
                        return this.injector.getInstance(Key.get(TravelTimeCalculator.class, (Annotation)Names.named(mode))).getLinkTravelTimes();
                    }
                });
            }
        } else {
            this.bind(TravelTimeCalculator.class).in(Singleton.class);
            if (this.getConfig().travelTimeCalculator().isCalculateLinkTravelTimes()) {
                for (String mode : this.getConfig().plansCalcRoute().getNetworkModes()) {
                    this.addTravelTimeBinding(mode).toProvider(ObservedLinkTravelTimes.class);
                }
            }
            if (this.getConfig().travelTimeCalculator().isCalculateLinkToLinkTravelTimes()) {
                this.bind(LinkToLinkTravelTime.class).toProvider(ObservedLinkToLinkTravelTimes.class);
            }
        }
    }

    private static class ObservedLinkToLinkTravelTimes
    implements Provider<LinkToLinkTravelTime> {
        @Inject
        TravelTimeCalculator travelTimeCalculator;

        private ObservedLinkToLinkTravelTimes() {
        }

        @Override
        public LinkToLinkTravelTime get() {
            return this.travelTimeCalculator.getLinkToLinkTravelTimes();
        }
    }

    private static class ObservedLinkTravelTimes
    implements Provider<TravelTime> {
        @Inject
        TravelTimeCalculator travelTimeCalculator;

        private ObservedLinkTravelTimes() {
        }

        @Override
        public TravelTime get() {
            return this.travelTimeCalculator.getLinkTravelTimes();
        }
    }

    private static class SingleModeTravelTimeCalculatorProvider
    implements Provider<TravelTimeCalculator> {
        @Inject
        TravelTimeCalculatorConfigGroup config;
        @Inject
        EventsManager eventsManager;
        @Inject
        Network network;
        private String mode;

        SingleModeTravelTimeCalculatorProvider(String mode) {
            this.mode = mode;
        }

        @Override
        public TravelTimeCalculator get() {
            TravelTimeCalculator.Builder builder = new TravelTimeCalculator.Builder(this.network);
            builder.setTimeslice(this.config.getTraveltimeBinSize());
            builder.setMaxTime(this.config.getMaxTime());
            builder.setCalculateLinkTravelTimes(this.config.isCalculateLinkTravelTimes());
            builder.setCalculateLinkToLinkTravelTimes(this.config.isCalculateLinkToLinkTravelTimes());
            builder.setFilterModes(true);
            builder.setAnalyzedModes(CollectionUtils.stringToSet(this.mode));
            builder.configure(this.config);
            TravelTimeCalculator calculator = builder.build();
            this.eventsManager.addHandler(calculator);
            return calculator;
        }
    }
}

