/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.trafficmonitoring.TravelTimeData;

class TravelTimeDataArray
extends TravelTimeData {
    private static final Logger log = Logger.getLogger(TravelTimeDataArray.class);
    private final double[] timeSum;
    private final int[] timeCnt;
    private final double[] travelTimes;
    private final Link link;

    public TravelTimeDataArray(Link link, int numSlots) {
        this.timeSum = new double[numSlots];
        this.timeCnt = new int[numSlots];
        this.travelTimes = new double[numSlots];
        this.link = link;
        this.resetTravelTimes();
    }

    @Override
    public void resetTravelTimes() {
        for (int i = 0; i < this.timeSum.length; ++i) {
            this.timeSum[i] = 0.0;
            this.timeCnt[i] = 0;
            this.travelTimes[i] = -1.0;
        }
    }

    @Override
    public void setTravelTime(int timeSlot, double traveltime) {
        this.timeSum[timeSlot] = traveltime;
        this.timeCnt[timeSlot] = 1;
        this.travelTimes[timeSlot] = traveltime;
    }

    @Override
    public void addTravelTime(int timeSlot, double traveltime) {
        double sum = this.timeSum[timeSlot];
        int cnt = this.timeCnt[timeSlot];
        this.timeSum[timeSlot] = sum += traveltime;
        this.timeCnt[timeSlot] = ++cnt;
        this.travelTimes[timeSlot] = -1.0;
    }

    @Override
    public double getTravelTime(int timeSlot, double now) {
        double ttime = this.travelTimes[timeSlot];
        if (ttime >= 0.0) {
            return ttime;
        }
        int cnt = this.timeCnt[timeSlot];
        if (cnt == 0) {
            this.travelTimes[timeSlot] = this.link.getLength() / this.link.getFreespeed(now);
            return this.travelTimes[timeSlot];
        }
        double sum = this.timeSum[timeSlot];
        this.travelTimes[timeSlot] = sum / (double)cnt;
        return this.travelTimes[timeSlot];
    }
}

