/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.trafficmonitoring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.trafficmonitoring.TravelTimeData;
import org.matsim.core.utils.misc.IntegerCache;

class TravelTimeDataHashMap
extends TravelTimeData {
    private final Map<Integer, TimeStruct> travelTimes = new ConcurrentHashMap<Integer, TimeStruct>();
    protected final Link link;

    public TravelTimeDataHashMap(Link link) {
        this.link = link;
    }

    @Override
    public void resetTravelTimes() {
        this.travelTimes.clear();
    }

    @Override
    public void setTravelTime(int timeSlice, double traveltime) {
        TimeStruct curr = this.travelTimes.get(IntegerCache.getInteger(timeSlice));
        if (curr != null) {
            curr.cnt = 1;
            curr.timeSum = traveltime;
        } else {
            this.travelTimes.put(IntegerCache.getInteger(timeSlice), new TimeStruct(traveltime, 1));
        }
    }

    @Override
    public void addTravelTime(int timeSlice, double traveltime) {
        TimeStruct curr = this.travelTimes.get(IntegerCache.getInteger(timeSlice));
        if (curr != null) {
            ++curr.cnt;
            curr.timeSum += traveltime;
        } else {
            this.travelTimes.put(IntegerCache.getInteger(timeSlice), new TimeStruct(traveltime, 1));
        }
    }

    @Override
    public double getTravelTime(int timeSlice, double now) {
        TimeStruct ts = this.travelTimes.get(IntegerCache.getInteger(timeSlice));
        if (ts == null) {
            Link r = this.link;
            return NetworkUtils.getFreespeedTravelTime(r, now);
        }
        return ts.timeSum / (double)ts.cnt;
    }

    private static class TimeStruct {
        public double timeSum;
        public int cnt;

        public TimeStruct(double timeSum, int cnt) {
            this.cnt = cnt;
            this.timeSum = timeSum;
        }
    }
}

