/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.charts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.matsim.core.utils.charts.ChartUtil;

public class BarChart
extends ChartUtil {
    private final String[] categories;
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private final CategoryPlot plot;

    public BarChart(String title, String xAxisLabel, String yAxisLabel) {
        this(title, xAxisLabel, yAxisLabel, new String[0]);
    }

    public BarChart(String title, String xAxisLabel, String yAxisLabel, String[] categories) {
        super(title, xAxisLabel, yAxisLabel);
        this.chart = this.createChart(title, xAxisLabel, yAxisLabel, this.dataset);
        this.plot = this.chart.getCategoryPlot();
        this.categories = (String[])categories.clone();
        this.addDefaultFormatting();
        CategoryAxis axis1 = this.plot.getDomainAxis();
        axis1.setCategoryMargin(0.2);
        BarRenderer renderer = (BarRenderer)this.plot.getRenderer();
        renderer.setItemMargin(0.1);
    }

    @Override
    public JFreeChart getChart() {
        return this.chart;
    }

    private JFreeChart createChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset dataset) {
        return ChartFactory.createBarChart(title, categoryAxisLabel, valueAxisLabel, dataset, PlotOrientation.VERTICAL, true, false, false);
    }

    public void addSeries(String title, double[] values) {
        int cnt = 1;
        for (double value : values) {
            String category = cnt > this.categories.length ? Integer.toString(cnt) : this.categories[cnt - 1];
            this.dataset.addValue(value, (Comparable)((Object)title), (Comparable)((Object)category));
            ++cnt;
        }
    }
}

