/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.charts;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.ImageTitle;
import org.jfree.chart.ui.HorizontalAlignment;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.VerticalAlignment;
import org.matsim.core.gbl.MatsimResource;

public abstract class ChartUtil {
    protected final String chartTitle;
    protected final String xAxisLabel;
    protected final String yAxisLabel;
    protected JFreeChart chart = null;

    public ChartUtil(String title, String xAxisLabel, String yAxisLabel) {
        this.chartTitle = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
    }

    public abstract JFreeChart getChart();

    public void saveAsPng(String filename, int width, int height) {
        try {
            ChartUtils.saveChartAsPNG(new File(filename), this.getChart(), width, height, null, true, 9);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMatsimLogo() {
        try {
            Image image = MatsimResource.getAsImage("matsim_logo_transparent_small.png");
            ImageTitle subtitle = new ImageTitle(image, RectangleEdge.BOTTOM, HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM);
            this.chart.addSubtitle(subtitle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addDefaultFormatting() {
        this.chart.setBackgroundPaint(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
    }
}

