/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.charts;

import org.apache.log4j.Logger;
import org.matsim.core.utils.charts.BarChart;
import org.matsim.core.utils.charts.LineChart;
import org.matsim.core.utils.charts.StackedBarChart;
import org.matsim.core.utils.charts.XYLineChart;
import org.matsim.core.utils.charts.XYScatterChart;

public class Demo {
    private static final Logger log = Logger.getLogger(Demo.class);
    private static final String TITLE = "TITLE";
    private static final String X_AXIS = "x-axis";
    private static final String Y_AXIS = "y-axis";
    private static final String SERIE_1 = "serie 1";
    private static final String SERIE_2 = "serie 2";

    public void createBarChart(String filename) {
        BarChart chart = new BarChart(TITLE, X_AXIS, Y_AXIS, new String[]{"A", "B", "C"});
        chart.addSeries(SERIE_1, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.addMatsimLogo();
        chart.saveAsPng(filename, 800, 600);
    }

    public void createStackedBarChart(String filename) {
        StackedBarChart chart = new StackedBarChart(TITLE, X_AXIS, Y_AXIS, new String[]{"A", "B", "C"});
        chart.addSeries(SERIE_1, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.addMatsimLogo();
        chart.saveAsPng(filename, 800, 600);
    }

    public void createLineChart(String filename) {
        LineChart chart = new LineChart(TITLE, X_AXIS, Y_AXIS, new String[]{"A", "B", "C"});
        chart.addSeries(SERIE_1, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.saveAsPng(filename, 800, 600);
    }

    public void createXYLineChart(String filename) {
        XYLineChart chart = new XYLineChart(TITLE, X_AXIS, Y_AXIS);
        chart.addSeries(SERIE_1, new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{1.0, 5.0, 2.0, 4.0, 3.0}, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.saveAsPng(filename, 800, 600);
    }

    public void createXYLogLogLineChart(String filename) {
        XYLineChart chart = new XYLineChart(TITLE, X_AXIS, Y_AXIS, true);
        chart.addSeries(SERIE_1, new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{1.0, 5.0, 2.0, 4.0, 3.0}, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.saveAsPng(filename, 800, 600);
    }

    public void createXYScatterChart(String filename) {
        XYScatterChart chart = new XYScatterChart(TITLE, X_AXIS, Y_AXIS);
        chart.addSeries(SERIE_1, new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new double[]{1.0, 5.0, 2.0, 3.0, 4.5});
        chart.addSeries(SERIE_2, new double[]{1.0, 5.0, 2.0, 4.0, 3.0}, new double[]{2.0, 3.0, 3.0, 1.5, 4.5});
        chart.saveAsPng(filename, 800, 600);
    }

    public static void main(String[] args) {
        log.info("start to write demo charts...");
        Demo demo = new Demo();
        demo.createBarChart("./output/barchart.png");
        demo.createStackedBarChart("./output/stackedbarchart.png");
        demo.createLineChart("./output/linechart.png");
        demo.createXYLineChart("./output/xylinechart.png");
        demo.createXYLogLogLineChart("./output/xylineloglogchart.png");
        demo.createXYScatterChart("./output/xyscatterchart.png");
        log.info("charts written to output directory at ./output/!");
    }
}

