/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.charts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.matsim.core.utils.charts.ChartUtil;

public class XYScatterChart
extends ChartUtil {
    private final XYSeriesCollection dataset;
    private final boolean isLogarithmicAxis;

    public XYScatterChart(String title, String xAxisLabel, String yAxisLabel) {
        this(title, xAxisLabel, yAxisLabel, false);
    }

    public XYScatterChart(String title, String xAxisLabel, String yAxisLabel, boolean isLogarithmicAxis) {
        super(title, xAxisLabel, yAxisLabel);
        this.isLogarithmicAxis = isLogarithmicAxis;
        this.dataset = new XYSeriesCollection();
        this.chart = this.createChart(title, xAxisLabel, yAxisLabel, this.dataset);
        this.addDefaultFormatting();
    }

    @Override
    public JFreeChart getChart() {
        return this.chart;
    }

    private JFreeChart createChart(String title, String categoryAxisLabel, String valueAxisLabel, XYSeriesCollection dataset) {
        JFreeChart c = ChartFactory.createScatterPlot(title, categoryAxisLabel, valueAxisLabel, dataset, PlotOrientation.VERTICAL, true, false, false);
        if (this.isLogarithmicAxis) {
            XYPlot p = (XYPlot)c.getPlot();
            LogarithmicAxis axis_x = new LogarithmicAxis(this.xAxisLabel);
            LogarithmicAxis axis_y = new LogarithmicAxis(this.yAxisLabel);
            axis_x.setAllowNegativesFlag(false);
            axis_y.setAllowNegativesFlag(false);
            p.setDomainAxis(axis_x);
            p.setRangeAxis(axis_y);
        }
        return c;
    }

    public void addSeries(String title, double[] xs, double[] ys) {
        XYSeries series = new XYSeries((Comparable)((Object)title), false, true);
        int n = Math.min(xs.length, ys.length);
        for (int i = 0; i < n; ++i) {
            series.add(xs[i], ys[i]);
        }
        this.dataset.addSeries(series);
    }
}

