/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.core.utils.misc.StringUtils;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static final <T> String idSetToString(Set<Id<T>> values) {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (Id<T> id : values) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(id.toString());
            isFirst = false;
        }
        return str.toString();
    }

    public static final String setToString(Set<String> values) {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (String s2 : values) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(s2);
            isFirst = false;
        }
        return str.toString();
    }

    public static final String arrayToString(String[] values) {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (String mode : values) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(mode);
            isFirst = false;
        }
        return str.toString();
    }

    public static final String[] stringToArray(String values) {
        Set<String> tmp = CollectionUtils.stringToSet(values);
        return tmp.toArray(new String[tmp.size()]);
    }

    public static final Set<String> stringToSet(String values) {
        if (values == null) {
            return Collections.emptySet();
        }
        String[] parts = StringUtils.explode(values, ',');
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (String part : parts) {
            String trimmed = part.trim();
            if (trimmed.length() <= 0) continue;
            tmp.add(trimmed.intern());
        }
        return tmp;
    }

    public static final Set<String> stringArrayToSet(String[] array) {
        if (array == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (String part : array) {
            String trimmed = part.trim();
            if (trimmed.length() <= 0) continue;
            tmp.add(trimmed.intern());
        }
        return tmp;
    }
}

