/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;

public class IdentifiableArrayMap<S, T extends Identifiable<S>>
implements Map<Id<S>, T> {
    private T[] data = new Identifiable[0];

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (T o : this.data) {
            if (!o.getId().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (T o : this.data) {
            if (!o.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object key) {
        for (T o : this.data) {
            if (!o.getId().equals(key)) continue;
            return o;
        }
        return null;
    }

    public T put(T value) {
        return this.put(value.getId(), value);
    }

    @Override
    public T put(Id<S> key, T value) {
        for (int i = 0; i < this.data.length; ++i) {
            T old = this.data[i];
            if (!old.getId().equals(key)) continue;
            this.data[i] = value;
            return old;
        }
        Identifiable[] tmp = new Identifiable[this.data.length + 1];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        tmp[this.data.length] = value;
        this.data = tmp;
        return null;
    }

    @Override
    public T remove(Object key) {
        for (int i = 0; i < this.data.length; ++i) {
            T old = this.data[i];
            if (!old.getId().equals(key)) continue;
            Identifiable[] tmp = new Identifiable[this.data.length - 1];
            if (i > 0) {
                System.arraycopy(this.data, 0, tmp, 0, i);
            }
            if (i + 1 < this.data.length) {
                System.arraycopy(this.data, i + 1, tmp, i, this.data.length - 1 - i);
            }
            this.data = tmp;
            return old;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Id<S>, ? extends T> m3) {
        for (Identifiable t : m3.values()) {
            this.put(t.getId(), (T)t);
        }
    }

    @Override
    public void clear() {
        this.data = new Identifiable[0];
    }

    @Override
    public Set<Id<S>> keySet() {
        LinkedHashSet<Id<S>> ids = new LinkedHashSet<Id<S>>();
        for (T o : this.data) {
            ids.add(o.getId());
        }
        return ids;
    }

    @Override
    public Collection<T> values() {
        return new ArrayCollection<T>(this.data);
    }

    @Override
    public Set<Map.Entry<Id<S>, T>> entrySet() {
        LinkedHashSet<Map.Entry<Id<S>, T>> entries = new LinkedHashSet<Map.Entry<Id<S>, T>>();
        for (T o : this.data) {
            entries.add(new Entry(o));
        }
        return entries;
    }

    private static class ArrayIterator<B>
    implements Iterator<B> {
        private final B[] data;
        private int pos = 0;

        public ArrayIterator(B[] data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.data.length;
        }

        @Override
        public B next() {
            if (this.pos < this.data.length) {
                B t = this.data[this.pos];
                ++this.pos;
                return t;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ArrayCollection<A>
    implements Collection<A> {
        private final A[] data;

        public ArrayCollection(A[] data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public boolean isEmpty() {
            return this.data.length == 0;
        }

        @Override
        public boolean contains(Object o) {
            for (A t : this.data) {
                if (t == null) {
                    return o == null;
                }
                if (!t.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<A> iterator() {
            return new ArrayIterator<A>(this.data);
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.data.clone();
        }

        @Override
        public <TT> TT[] toArray(TT[] a) {
            return (Object[])this.data.clone();
        }

        @Override
        public boolean add(A e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                boolean isPartOf = this.contains(o);
                if (isPartOf) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends A> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Entry<S, T extends Identifiable<S>>
    implements Map.Entry<Id<S>, T> {
        private final T t;

        public Entry(T t) {
            this.t = t;
        }

        @Override
        public Id<S> getKey() {
            return this.t.getId();
        }

        @Override
        public T getValue() {
            return this.t;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }
    }
}

