/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MapUtils {
    private MapUtils() {
    }

    public static <K, V> Collection<V> getCollection(K key, Map<K, Collection<V>> map) {
        Collection<V> coll = map.get(key);
        if (coll == null) {
            coll = new ArrayList<V>();
            map.put(key, coll);
        }
        return coll;
    }

    public static <K, V> List<V> getList(K key, Map<K, List<V>> map) {
        List<V> coll = map.get(key);
        if (coll == null) {
            coll = new ArrayList<V>();
            map.put(key, coll);
        }
        return coll;
    }

    public static <K, V> Set<V> getSet(K key, Map<K, Set<V>> map) {
        Set<V> coll = map.get(key);
        if (coll == null) {
            coll = new HashSet<V>();
            map.put(key, coll);
        }
        return coll;
    }

    public static <K, C, V> Map<C, V> getMap(K key, Map<K, Map<C, V>> map) {
        Map<C, V> coll = map.get(key);
        if (coll == null) {
            coll = new HashMap<C, V>();
            map.put(key, coll);
        }
        return coll;
    }

    public static <K, T> T getArbitraryObject(K key, Map<K, T> map, Factory<T> fact) {
        T coll = map.get(key);
        if (coll == null) {
            coll = fact.create();
            map.put(key, coll);
        }
        return coll;
    }

    public static <K> Double getDouble(K key, Map<K, Double> map, double initialValue) {
        Double d = map.get(key);
        if (d == null) {
            d = initialValue;
            map.put(key, d);
        }
        return d;
    }

    public static <K> double addToDouble(K key, Map<K, Double> map, double initialValue, double toAdd) {
        double newValue = MapUtils.getDouble(key, map, initialValue) + toAdd;
        map.put(key, newValue);
        return newValue;
    }

    public static <K> Integer getInteger(K key, Map<K, Integer> map, int initialValue) {
        Integer i = map.get(key);
        if (i == null) {
            i = initialValue;
            map.put(key, i);
        }
        return i;
    }

    public static <K> double addToInteger(K key, Map<K, Integer> map, int initialValue, int toAdd) {
        int newValue = MapUtils.getInteger(key, map, initialValue) + toAdd;
        map.put(key, newValue);
        return newValue;
    }

    public static <K, V> Collection<V> get(Iterable<K> keys, Map<K, V> map) {
        ArrayList<V> coll = new ArrayList<V>();
        for (K k : keys) {
            coll.add(map.get(k));
        }
        return coll;
    }

    public static class DefaultFactory<T>
    implements Factory<T> {
        private final Class<? extends T> theClass;

        public DefaultFactory(Class<? extends T> theClass) {
            this.theClass = theClass;
        }

        @Override
        public T create() {
            try {
                return this.theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Factory<T> {
        public T create();
    }
}

