/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.matsim.core.utils.collections.RouterPriorityQueue;

public class PseudoRemovePriorityQueue<E>
implements RouterPriorityQueue<E> {
    private final PriorityQueue<PseudoEntry<E>> delegate;
    final Map<E, PseudoEntry<E>> lastEntry;

    public PseudoRemovePriorityQueue(int initialCapacity) {
        this.delegate = new PriorityQueue(initialCapacity, new PseudoComparator());
        this.lastEntry = new LinkedHashMap<E, PseudoEntry<E>>(initialCapacity);
    }

    @Override
    public boolean add(E o, double priority) {
        if (o == null) {
            throw new NullPointerException();
        }
        PseudoEntry<E> entry = new PseudoEntry<E>(o, priority);
        if (this.lastEntry.containsKey(o)) {
            return false;
        }
        if (this.delegate.add(entry)) {
            this.lastEntry.put(o, entry);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        PseudoEntry<E> entry = this.delegate.poll();
        while (entry != null && !entry.valid) {
            entry = this.delegate.poll();
        }
        if (entry == null) {
            return null;
        }
        this.lastEntry.remove(entry.value);
        return entry.value;
    }

    @Override
    public boolean remove(E o) {
        PseudoEntry<E> entry = this.lastEntry.remove(o);
        if (entry != null && entry.valid) {
            entry.valid = false;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.lastEntry.size();
    }

    @Override
    public E peek() {
        PseudoEntry<E> entry = this.delegate.peek();
        while (entry != null && !entry.valid) {
            this.delegate.poll();
            entry = this.delegate.peek();
        }
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    @Override
    public boolean isEmpty() {
        return this.lastEntry.isEmpty();
    }

    @Override
    public boolean decreaseKey(E value, double priority) {
        this.remove(value);
        return this.add(value, priority);
    }

    @Override
    public void reset() {
        this.delegate.clear();
        this.lastEntry.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            final Iterator<E> iterDelegate;
            {
                this.iterDelegate = PseudoRemovePriorityQueue.this.lastEntry.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterDelegate.hasNext();
            }

            @Override
            public E next() {
                return this.iterDelegate.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class PseudoComparator<T>
    implements Comparator<PseudoEntry<T>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        PseudoComparator() {
        }

        @Override
        public int compare(PseudoEntry<T> o1, PseudoEntry<T> o2) {
            return Double.compare(o1.priority, o2.priority);
        }
    }

    private static class PseudoEntry<E> {
        final E value;
        final double priority;
        boolean valid = true;

        public PseudoEntry(E value, double priority) {
            this.value = value;
            this.priority = priority;
        }
    }
}

