/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class QuadTree<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Node<T> top = null;
    private int size = 0;
    private transient int modCount = 0;
    volatile transient Collection<T> values = null;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
        this.values = null;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
        this.values = null;
    }

    public QuadTree(double minX, double minY, double maxX, double maxY) {
        this.top = new Node(minX, minY, maxX, maxY);
    }

    public boolean put(double x, double y, T value) {
        if (!((Node)this.top).bounds.containsOrEquals(x, y)) {
            throw new IllegalArgumentException("cannot add a point at x=" + x + ", y=" + y + " with bounds " + ((Node)this.top).bounds);
        }
        if (this.top.put(x, y, value)) {
            this.incrementSize();
            return true;
        }
        return false;
    }

    public boolean remove(double x, double y, T value) {
        if (this.top.remove(x, y, value)) {
            this.decrementSize();
            return true;
        }
        return false;
    }

    public void clear() {
        this.top.clear();
        this.size = 0;
        ++this.modCount;
    }

    public T getClosest(double x, double y) {
        return this.top.get(x, y, new MutableDouble(Double.POSITIVE_INFINITY));
    }

    public Collection<T> getDisk(double x, double y, double distance) {
        return this.top.get(x, y, distance, new ArrayList());
    }

    public Collection<T> getRing(double x, double y, double r_min, double r_max) {
        return this.top.get(x, y, r_min, r_max, new ArrayList());
    }

    public Collection<T> getElliptical(double x1, double y1, double x2, double y2, double distance) {
        if (Math.pow(distance, 2.0) < Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)) {
            throw new IllegalArgumentException("wrong ellipse specification: distance must be greater than distance between foci. x1=" + x1 + " y1=" + y1 + " x2=" + x2 + " y2=" + y2 + " distance=" + distance);
        }
        return this.top.getElliptical(x1, y1, x2, y2, distance, new ArrayList());
    }

    public Collection<T> getRectangle(Rect bounds, Collection<T> values1) {
        return this.top.get(bounds, values1);
    }

    public Collection<T> getRectangle(double minX, double minY, double maxX, double maxY, Collection<T> values1) {
        return this.getRectangle(new Rect(minX, minY, maxX, maxY), values1);
    }

    public int execute(Rect bounds, Executor<T> executor) {
        if (bounds == null) {
            return this.top.execute(this.top.getBounds(), executor);
        }
        return this.top.execute(bounds, executor);
    }

    public int execute(double minX, double minY, double maxX, double maxY, Executor<T> executor) {
        return this.execute(new Rect(minX, minY, maxX, maxY), executor);
    }

    public int size() {
        return this.size;
    }

    public double getMinEasting() {
        return this.top.getBounds().minX;
    }

    public double getMaxEasting() {
        return this.top.getBounds().maxX;
    }

    public double getMinNorthing() {
        return this.top.getBounds().minY;
    }

    public double getMaxNorthing() {
        return this.top.getBounds().maxY;
    }

    public Collection<T> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<T>(){

                @Override
                public Iterator<T> iterator() {
                    Iterator iterator = new Iterator<T>(){
                        private final int expectedModCount;
                        private Leaf<T> currentLeaf;
                        private int nextIndex;
                        private T next;
                        {
                            this.expectedModCount = QuadTree.this.modCount;
                            this.currentLeaf = QuadTree.this.firstLeaf();
                            this.nextIndex = 0;
                            this.next = this.first();
                        }

                        private T first() {
                            if (this.currentLeaf == null) {
                                return null;
                            }
                            this.nextIndex = 0;
                            this.loadNext();
                            return this.next;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public T next() {
                            if (this.next == null) {
                                return null;
                            }
                            if (QuadTree.this.modCount != this.expectedModCount) {
                                throw new ConcurrentModificationException();
                            }
                            Object current = this.next;
                            this.loadNext();
                            return current;
                        }

                        private void loadNext() {
                            boolean searching = true;
                            while (searching) {
                                int size;
                                int n = size = this.currentLeaf.value != null ? 1 : this.currentLeaf.values.size();
                                if (this.nextIndex < size) {
                                    ++this.nextIndex;
                                    this.next = this.currentLeaf.value != null ? this.currentLeaf.value : this.currentLeaf.values.get(this.nextIndex - 1);
                                    searching = false;
                                    continue;
                                }
                                this.currentLeaf = QuadTree.this.nextLeaf(this.currentLeaf);
                                if (this.currentLeaf == null) {
                                    this.next = null;
                                    searching = false;
                                    continue;
                                }
                                this.nextIndex = 0;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                    return iterator;
                }

                @Override
                public int size() {
                    return QuadTree.this.size;
                }
            };
        }
        return this.values;
    }

    private Leaf<T> firstLeaf() {
        return this.top.firstLeaf();
    }

    private Leaf<T> nextLeaf(Leaf<T> currentLeaf) {
        return this.top.nextLeaf(currentLeaf);
    }

    public static interface Executor<T> {
        public void execute(double var1, double var3, T var5);
    }

    protected static class Node<T>
    implements Serializable {
        private static final long serialVersionUID = 8151154226742383421L;
        private static final int MAX_CHILDS = 128;
        private ArrayList<Leaf<T>> leaves = null;
        private boolean hasChilds = false;
        private Node<T> northwest = null;
        private Node<T> northeast = null;
        private Node<T> southeast = null;
        private Node<T> southwest = null;
        private final Rect bounds;

        public Node(double minX, double minY, double maxX, double maxY) {
            this.bounds = new Rect(minX, minY, maxX, maxY);
        }

        public boolean put(Leaf<T> leaf) {
            if (this.hasChilds) {
                return this.getChild(leaf.x, leaf.y).put(leaf);
            }
            if (this.leaves == null) {
                this.leaves = new ArrayList();
                this.leaves.add(leaf);
                return true;
            }
            for (Leaf<T> l : this.leaves) {
                if (l.x != leaf.x || l.y != leaf.y) continue;
                if (leaf.value == l.value) {
                    return false;
                }
                if (l.values != null) {
                    if (l.values.contains(leaf.value)) {
                        return false;
                    }
                    l.values.add(leaf.value);
                    return true;
                }
                if (l.value == null) {
                    l.value = leaf.value;
                    return true;
                }
                l.values = new ArrayList(3);
                l.values.add(l.value);
                l.value = null;
                l.values.add(leaf.value);
                return true;
            }
            if (this.leaves.size() < 128) {
                this.leaves.add(leaf);
                return true;
            }
            this.split();
            return this.getChild(leaf.x, leaf.y).put(leaf);
        }

        public boolean put(double x, double y, T value) {
            return this.put(new Leaf<T>(x, y, value));
        }

        public boolean remove(double x, double y, T value) {
            if (this.hasChilds) {
                return this.getChild(x, y).remove(x, y, value);
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    if (leaf.x != x || leaf.y != y) continue;
                    if (leaf.value == value) {
                        leaf.value = null;
                        this.leaves.remove(leaf);
                        return true;
                    }
                    if (leaf.values == null || !leaf.values.remove(value)) continue;
                    if (leaf.values.size() == 0) {
                        this.leaves.remove(leaf);
                    }
                    return true;
                }
            }
            return false;
        }

        public void clear() {
            if (this.hasChilds) {
                this.northwest.clear();
                this.northeast.clear();
                this.southeast.clear();
                this.southwest.clear();
                this.northwest = null;
                this.northeast = null;
                this.southeast = null;
                this.southwest = null;
                this.hasChilds = false;
            } else if (this.leaves != null) {
                this.leaves = null;
            }
        }

        T get(double x, double y, MutableDouble bestDistance) {
            if (this.hasChilds) {
                T value;
                T closest = null;
                Node<T> bestChild = this.getChild(x, y);
                if (bestChild != null) {
                    closest = bestChild.get(x, y, bestDistance);
                }
                if (bestChild != this.northwest && this.northwest.bounds.calcDistance(x, y) < bestDistance.value && (value = this.northwest.get(x, y, bestDistance)) != null) {
                    closest = value;
                }
                if (bestChild != this.northeast && this.northeast.bounds.calcDistance(x, y) < bestDistance.value && (value = this.northeast.get(x, y, bestDistance)) != null) {
                    closest = value;
                }
                if (bestChild != this.southeast && this.southeast.bounds.calcDistance(x, y) < bestDistance.value && (value = this.southeast.get(x, y, bestDistance)) != null) {
                    closest = value;
                }
                if (bestChild != this.southwest && this.southwest.bounds.calcDistance(x, y) < bestDistance.value && (value = this.southwest.get(x, y, bestDistance)) != null) {
                    closest = value;
                }
                return closest;
            }
            T closest = null;
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    double distance = Math.sqrt((leaf.x - x) * (leaf.x - x) + (leaf.y - y) * (leaf.y - y));
                    if (!(distance < bestDistance.value)) continue;
                    bestDistance.value = distance;
                    closest = leaf.value != null ? leaf.value : leaf.values.get(0);
                }
            }
            return closest;
        }

        Collection<T> getElliptical(double x1, double y1, double x2, double y2, double maxDistance, Collection<T> values) {
            assert (Math.pow(maxDistance, 2.0) >= Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
            if (this.hasChilds) {
                double sw1;
                double se1;
                double ne1;
                double nw1 = this.northwest.bounds.calcDistance(x1, y1);
                if (nw1 <= maxDistance && nw1 + this.northwest.bounds.calcDistance(x2, y2) <= maxDistance) {
                    this.northwest.getElliptical(x1, y1, x2, y2, maxDistance, values);
                }
                if ((ne1 = this.northeast.bounds.calcDistance(x1, y1)) <= maxDistance && ne1 + this.northeast.bounds.calcDistance(x2, y2) <= maxDistance) {
                    this.northeast.getElliptical(x1, y1, x2, y2, maxDistance, values);
                }
                if ((se1 = this.southeast.bounds.calcDistance(x1, y1)) <= maxDistance && se1 + this.southeast.bounds.calcDistance(x2, y2) <= maxDistance) {
                    this.southeast.getElliptical(x1, y1, x2, y2, maxDistance, values);
                }
                if ((sw1 = this.southwest.bounds.calcDistance(x1, y1)) <= maxDistance && sw1 + this.southwest.bounds.calcDistance(x2, y2) <= maxDistance) {
                    this.southwest.getElliptical(x1, y1, x2, y2, maxDistance, values);
                }
                return values;
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    double distance2;
                    double distance1 = Math.sqrt((leaf.x - x1) * (leaf.x - x1) + (leaf.y - y1) * (leaf.y - y1));
                    if (!(distance1 <= maxDistance) || !(distance1 + (distance2 = Math.sqrt((leaf.x - x2) * (leaf.x - x2) + (leaf.y - y2) * (leaf.y - y2))) <= maxDistance)) continue;
                    if (leaf.value != null) {
                        values.add(leaf.value);
                        continue;
                    }
                    values.addAll(leaf.values);
                }
            }
            return values;
        }

        Collection<T> get(double x, double y, double maxDistance, Collection<T> values) {
            if (this.hasChilds) {
                if (this.northwest.bounds.calcDistance(x, y) <= maxDistance) {
                    this.northwest.get(x, y, maxDistance, values);
                }
                if (this.northeast.bounds.calcDistance(x, y) <= maxDistance) {
                    this.northeast.get(x, y, maxDistance, values);
                }
                if (this.southeast.bounds.calcDistance(x, y) <= maxDistance) {
                    this.southeast.get(x, y, maxDistance, values);
                }
                if (this.southwest.bounds.calcDistance(x, y) <= maxDistance) {
                    this.southwest.get(x, y, maxDistance, values);
                }
                return values;
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    double distance = Math.sqrt((leaf.x - x) * (leaf.x - x) + (leaf.y - y) * (leaf.y - y));
                    if (!(distance <= maxDistance)) continue;
                    if (leaf.value != null) {
                        values.add(leaf.value);
                        continue;
                    }
                    values.addAll(leaf.values);
                }
            }
            return values;
        }

        Collection<T> get(double x, double y, double r_min, double r_max, Collection<T> values) {
            if (this.hasChilds) {
                this.stepInto(this.northwest, x, y, r_min, r_max, values);
                this.stepInto(this.northeast, x, y, r_min, r_max, values);
                this.stepInto(this.southeast, x, y, r_min, r_max, values);
                this.stepInto(this.southwest, x, y, r_min, r_max, values);
                return values;
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    double distance = Math.sqrt((leaf.x - x) * (leaf.x - x) + (leaf.y - y) * (leaf.y - y));
                    if (!(distance <= r_max) || !(distance >= r_min)) continue;
                    if (leaf.value != null) {
                        values.add(leaf.value);
                        continue;
                    }
                    values.addAll(leaf.values);
                }
            }
            return values;
        }

        private void stepInto(Node node, double x, double y, double r_min, double r_max, Collection<T> values) {
            double minDistance = node.bounds.calcDistance(x, y);
            double maxDistance = node.bounds.calcMaxDistance(x, y);
            if (minDistance <= r_max && maxDistance >= r_min) {
                node.get(x, y, r_min, r_max, values);
            }
        }

        Collection<T> get(Rect bounds, Collection<T> values) {
            if (this.hasChilds) {
                if (this.northwest.bounds.intersects(bounds)) {
                    this.northwest.get(bounds, values);
                }
                if (this.northeast.bounds.intersects(bounds)) {
                    this.northeast.get(bounds, values);
                }
                if (this.southeast.bounds.intersects(bounds)) {
                    this.southeast.get(bounds, values);
                }
                if (this.southwest.bounds.intersects(bounds)) {
                    this.southwest.get(bounds, values);
                }
                return values;
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    if (!bounds.containsOrEquals(leaf.x, leaf.y)) continue;
                    if (leaf.value != null) {
                        values.add(leaf.value);
                        continue;
                    }
                    values.addAll(leaf.values);
                }
            }
            return values;
        }

        int execute(Rect globalBounds, Executor<T> executor) {
            int count = 0;
            if (this.hasChilds) {
                if (this.northwest.bounds.intersects(globalBounds)) {
                    count += this.northwest.execute(globalBounds, executor);
                }
                if (this.northeast.bounds.intersects(globalBounds)) {
                    count += this.northeast.execute(globalBounds, executor);
                }
                if (this.southeast.bounds.intersects(globalBounds)) {
                    count += this.southeast.execute(globalBounds, executor);
                }
                if (this.southwest.bounds.intersects(globalBounds)) {
                    count += this.southwest.execute(globalBounds, executor);
                }
                return count;
            }
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    if (!globalBounds.contains(leaf.x, leaf.y)) continue;
                    if (leaf.value != null) {
                        ++count;
                        executor.execute(leaf.x, leaf.y, leaf.value);
                        continue;
                    }
                    count += leaf.values.size();
                    for (Object object : leaf.values) {
                        executor.execute(leaf.x, leaf.y, object);
                    }
                }
            }
            return count;
        }

        private void split() {
            this.northwest = new Node<T>(this.bounds.minX, this.bounds.centerY, this.bounds.centerX, this.bounds.maxY);
            this.northeast = new Node<T>(this.bounds.centerX, this.bounds.centerY, this.bounds.maxX, this.bounds.maxY);
            this.southeast = new Node<T>(this.bounds.centerX, this.bounds.minY, this.bounds.maxX, this.bounds.centerY);
            this.southwest = new Node<T>(this.bounds.minX, this.bounds.minY, this.bounds.centerX, this.bounds.centerY);
            this.hasChilds = true;
            if (this.leaves != null) {
                for (Leaf<T> leaf : this.leaves) {
                    this.getChild(leaf.x, leaf.y).put(leaf);
                }
                this.leaves = null;
            }
        }

        private Node<T> getChild(double x, double y) {
            if (this.hasChilds) {
                if (x < this.bounds.centerX) {
                    if (y < this.bounds.centerY) {
                        return this.southwest;
                    }
                    return this.northwest;
                }
                if (y < this.bounds.centerY) {
                    return this.southeast;
                }
                return this.northeast;
            }
            return null;
        }

        Leaf<T> firstLeaf() {
            if (this.hasChilds) {
                Leaf<T> leaf = this.southwest.firstLeaf();
                if (leaf == null) {
                    leaf = this.northwest.firstLeaf();
                }
                if (leaf == null) {
                    leaf = this.southeast.firstLeaf();
                }
                if (leaf == null) {
                    leaf = this.northeast.firstLeaf();
                }
                return leaf;
            }
            return this.leaves == null || this.leaves.isEmpty() ? null : this.leaves.get(0);
        }

        boolean nextLeaf(Leaf<T> currentLeaf, MutableLeaf<T> nextLeaf) {
            int idx;
            if (this.hasChilds) {
                boolean found = false;
                if (currentLeaf.x <= this.bounds.centerX && currentLeaf.y <= this.bounds.centerY && (found = this.southwest.nextLeaf(currentLeaf, nextLeaf))) {
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.northwest.firstLeaf();
                    }
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.southeast.firstLeaf();
                    }
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.northeast.firstLeaf();
                    }
                    return true;
                }
                if (currentLeaf.x <= this.bounds.centerX && currentLeaf.y >= this.bounds.centerY && (found = this.northwest.nextLeaf(currentLeaf, nextLeaf))) {
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.southeast.firstLeaf();
                    }
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.northeast.firstLeaf();
                    }
                    return true;
                }
                if (currentLeaf.x >= this.bounds.centerX && currentLeaf.y <= this.bounds.centerY && (found = this.southeast.nextLeaf(currentLeaf, nextLeaf))) {
                    if (nextLeaf.value == null) {
                        nextLeaf.value = this.northeast.firstLeaf();
                    }
                    return true;
                }
                if (currentLeaf.x >= this.bounds.centerX && currentLeaf.y >= this.bounds.centerY) {
                    return this.northeast.nextLeaf(currentLeaf, nextLeaf);
                }
                return false;
            }
            if (this.leaves != null && (idx = this.leaves.indexOf(currentLeaf)) >= 0) {
                if (idx + 1 < this.leaves.size()) {
                    nextLeaf.value = this.leaves.get(idx + 1);
                }
                return true;
            }
            return false;
        }

        public Leaf<T> nextLeaf(Leaf<T> currentLeaf) {
            MutableLeaf nextLeaf = new MutableLeaf(null);
            this.nextLeaf(currentLeaf, nextLeaf);
            return nextLeaf.value;
        }

        public Rect getBounds() {
            return this.bounds;
        }
    }

    protected static class Leaf<T>
    implements Serializable {
        private static final long serialVersionUID = -6527830222532634476L;
        public final double x;
        public final double y;
        public T value;
        public ArrayList<T> values;

        public Leaf(double x, double y, T value) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.values = null;
        }
    }

    public static class Rect
    implements Serializable {
        private static final long serialVersionUID = -837712701959689133L;
        public final double minX;
        public final double minY;
        public final double maxX;
        public final double maxY;
        public final double centerX;
        public final double centerY;

        public Rect(double minX, double minY, double maxX, double maxY) {
            this.minX = Math.min(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.maxX = Math.max(minX, maxX);
            this.maxY = Math.max(minY, maxY);
            this.centerX = (minX + maxX) / 2.0;
            this.centerY = (minY + maxY) / 2.0;
        }

        public double calcDistance(double x, double y) {
            double distanceX = this.minX <= x && x <= this.maxX ? 0.0 : Math.min(Math.abs(this.minX - x), Math.abs(this.maxX - x));
            double distanceY = this.minY <= y && y <= this.maxY ? 0.0 : Math.min(Math.abs(this.minY - y), Math.abs(this.maxY - y));
            return Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        }

        public double calcMaxDistance(double x, double y) {
            double distanceX = Math.max(Math.abs(this.minX - x), Math.abs(this.maxX - x));
            double distanceY = Math.max(Math.abs(this.minY - y), Math.abs(this.maxY - y));
            return Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        }

        public boolean contains(double x, double y) {
            return x >= this.minX && y >= this.minY && x < this.maxX && y < this.maxY;
        }

        public boolean containsOrEquals(double x, double y) {
            return x >= this.minX && y >= this.minY && x <= this.maxX && y <= this.maxY;
        }

        public boolean containsOrEquals(Rect rect) {
            return rect.minX >= this.minX && rect.minY >= this.minY && rect.maxX <= this.maxX && rect.maxY <= this.maxY;
        }

        public boolean intersects(Rect other) {
            if (this.maxX - this.minX < 0.0 || this.maxY - this.minY < 0.0) {
                return false;
            }
            return other.maxX >= this.minX && other.maxY >= this.minY && other.minX <= this.maxX && other.minY <= this.maxY;
        }

        public Rect intersection(Rect r) {
            double tx1 = this.minX;
            double ty1 = this.minY;
            double tx2 = this.maxX;
            double ty2 = this.maxY;
            if (this.minX < r.minX) {
                tx1 = r.minX;
            }
            if (this.minY < r.minY) {
                ty1 = r.minY;
            }
            if (tx2 > r.maxX) {
                tx2 = r.maxX;
            }
            if (ty2 > r.maxY) {
                ty2 = r.maxY;
            }
            if (tx2 - tx1 <= 0.0 || ty2 - ty1 <= 0.0) {
                return null;
            }
            return new Rect(tx1, ty1, tx2, ty2);
        }

        public Rect union(Rect r) {
            return new Rect(Math.min(this.minX, r.minX), Math.min(this.minY, r.minY), Math.max(this.maxX, r.maxX), Math.max(this.maxY, r.maxY));
        }

        public Rect scale(double scaleX, double scaleY) {
            return new Rect(this.minX - (scaleX *= this.centerX - this.minX), this.minY - (scaleY *= this.centerY - this.minY), this.maxX + scaleX, this.maxY + scaleY);
        }

        public String toString() {
            return "topLeft: (" + this.minX + "," + this.minY + ") bottomRight: (" + this.maxX + "," + this.maxY + ")";
        }
    }

    private static class MutableLeaf<T> {
        public Leaf<T> value;

        public MutableLeaf(Leaf<T> value) {
            this.value = value;
        }
    }

    private static class MutableDouble {
        public double value;

        public MutableDouble(double value) {
            this.value = value;
        }
    }
}

