/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.collections;

import java.io.Serializable;

public class Tuple<A, B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final A first;
    private final B second;

    public static <A, B> Tuple<A, B> of(A first, B second) {
        return new Tuple<A, B>(first, second);
    }

    public Tuple(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object other) {
        boolean secondEquals;
        if (!(other instanceof Tuple)) {
            return false;
        }
        Tuple o = (Tuple)other;
        if (this.first != null && this.second != null && o.first != null && o.second != null) {
            return this.first.equals(o.first) && this.second.equals(o.second);
        }
        boolean firstEquals = this.first == null && o.first == null;
        boolean bl = secondEquals = this.second == null && o.second == null;
        if (!firstEquals && this.first != null && o.first != null) {
            firstEquals = this.first.equals(o.first);
        }
        if (!secondEquals && this.second != null && o.second != null) {
            secondEquals = this.second.equals(o.second);
        }
        return firstEquals && secondEquals;
    }

    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[Tuple: [First: ");
        buffer.append(this.first.toString());
        buffer.append("], [Second: ");
        buffer.append(this.second.toString());
        buffer.append("]]");
        return buffer.toString();
    }
}

