/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry;

import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.matsim.api.core.v01.Coord;

public abstract class CoordUtils {
    private static final Logger LOG = Logger.getLogger(CoordUtils.class);
    private static boolean onlyOnceWarnGiven = false;

    public static Coordinate createGeotoolsCoordinate(Coord coord) {
        return new Coordinate(coord.getX(), coord.getY());
    }

    public static Coord createCoord(Coordinate coordinate) {
        return new Coord(coordinate.x, coordinate.y);
    }

    public static Coord createCoord(double xx, double yy) {
        return new Coord(xx, yy);
    }

    public static Coord createCoord(double xx, double yy, double zz) {
        return new Coord(xx, yy, zz);
    }

    public static Coord plus(Coord coord1, Coord coord2) {
        if (!coord1.hasZ() && !coord2.hasZ()) {
            double xx = coord1.getX() + coord2.getX();
            double yy = coord1.getY() + coord2.getY();
            return new Coord(xx, yy);
        }
        if (coord1.hasZ() && coord2.hasZ()) {
            double xx = coord1.getX() + coord2.getX();
            double yy = coord1.getY() + coord2.getY();
            double zz = coord1.getZ() + coord2.getZ();
            return new Coord(xx, yy, zz);
        }
        throw new RuntimeException("Cannot 'plus' coordinates if one has elevation (z) and the other not; coord1.hasZ=" + coord1.hasZ() + "; coord2.hasZ=" + coord2.hasZ());
    }

    public static Coord minus(Coord coord1, Coord coord2) {
        if (!coord1.hasZ() && !coord2.hasZ()) {
            double xx = coord1.getX() - coord2.getX();
            double yy = coord1.getY() - coord2.getY();
            return new Coord(xx, yy);
        }
        if (coord1.hasZ() && coord2.hasZ()) {
            double xx = coord1.getX() - coord2.getX();
            double yy = coord1.getY() - coord2.getY();
            double zz = coord1.getZ() - coord2.getZ();
            return new Coord(xx, yy, zz);
        }
        throw new RuntimeException("Cannot 'minus' coordinates if one has elevation (z) and the other not.");
    }

    public static Coord scalarMult(double alpha, Coord coord) {
        if (!coord.hasZ()) {
            double xx = alpha * coord.getX();
            double yy = alpha * coord.getY();
            return new Coord(xx, yy);
        }
        double xx = alpha * coord.getX();
        double yy = alpha * coord.getY();
        double zz = alpha * coord.getZ();
        return new Coord(xx, yy, zz);
    }

    public static Coord getCenter(Coord coord1, Coord coord2) {
        if (!coord1.hasZ() && !coord2.hasZ()) {
            double xx = 0.5 * (coord1.getX() + coord2.getX());
            double yy = 0.5 * (coord1.getY() + coord2.getY());
            return new Coord(xx, yy);
        }
        if (coord1.hasZ() && coord2.hasZ()) {
            double xx = 0.5 * (coord1.getX() + coord2.getX());
            double yy = 0.5 * (coord1.getY() + coord2.getY());
            double zz = 0.5 * (coord1.getZ() + coord2.getZ());
            return new Coord(xx, yy, zz);
        }
        throw new RuntimeException("Cannot get the center for coordinates if one has elevation (z) and the other not.");
    }

    public static double length(Coord coord) {
        if (!coord.hasZ()) {
            return Math.sqrt(coord.getX() * coord.getX() + coord.getY() * coord.getY());
        }
        return Math.sqrt(coord.getX() * coord.getX() + coord.getY() * coord.getY() + coord.getZ() * coord.getZ());
    }

    public static Coord rotateToRight(Coord coord) {
        if (!coord.hasZ()) {
            double y = -coord.getX();
            return new Coord(coord.getY(), y);
        }
        double y = -coord.getX();
        return new Coord(coord.getY(), y, coord.getZ());
    }

    public static Coord getCenterWOffset(Coord coord1, Coord coord2) {
        if (!coord1.hasZ() && !coord2.hasZ()) {
            Coord fromTo = CoordUtils.minus(coord2, coord1);
            Coord offset = CoordUtils.scalarMult(0.1, CoordUtils.rotateToRight(fromTo));
            Coord centerWOffset = CoordUtils.plus(CoordUtils.getCenter(coord1, coord2), offset);
            return centerWOffset;
        }
        if (coord1.hasZ() && coord2.hasZ()) {
            throw new RuntimeException("3D version not implemented.");
        }
        throw new RuntimeException("Cannot get the center for coordinates if one has elevation (z) and the other not.");
    }

    public static double calcEuclideanDistance(Coord coord, Coord other) {
        if (!coord.hasZ() && !other.hasZ()) {
            double xDiff = other.getX() - coord.getX();
            double yDiff = other.getY() - coord.getY();
            return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
        }
        if (coord.hasZ() && other.hasZ()) {
            double xDiff = other.getX() - coord.getX();
            double yDiff = other.getY() - coord.getY();
            double zDiff = other.getZ() - coord.getZ();
            return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        }
        LOG.warn("Mixed use of elevation in coordinates: " + coord.toString() + "; " + other.toString());
        LOG.warn("Returning projected coordinate distance (using x and y components only)");
        return CoordUtils.calcProjectedEuclideanDistance(coord, other);
    }

    public static double calcProjectedEuclideanDistance(Coord coord, Coord other) {
        double xDiff = other.getX() - coord.getX();
        double yDiff = other.getY() - coord.getY();
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static double dotProduct(Coord coord1, Coord coord2) {
        if (!coord1.hasZ() && !coord2.hasZ()) {
            return coord1.getX() * coord2.getX() + coord1.getY() * coord2.getY();
        }
        if (coord1.hasZ() && coord2.hasZ()) {
            return coord1.getX() * coord2.getX() + coord1.getY() * coord2.getY() + coord1.getZ() * coord2.getZ();
        }
        throw new RuntimeException("Cannot get the dot-product of coordinates if one has elevation (z) and the other not.");
    }

    public static double distancePointLinesegment(Coord lineFrom, Coord lineTo, Coord point) {
        if (!(lineFrom.hasZ() || lineTo.hasZ() || point.hasZ())) {
            double lineDX = lineTo.getX() - lineFrom.getX();
            double lineDY = lineTo.getY() - lineFrom.getY();
            if (lineDX == 0.0 && lineDY == 0.0) {
                return CoordUtils.calcEuclideanDistance(lineFrom, point);
            }
            double u = ((point.getX() - lineFrom.getX()) * lineDX + (point.getY() - lineFrom.getY()) * lineDY) / (lineDX * lineDX + lineDY * lineDY);
            if (u <= 0.0) {
                return CoordUtils.calcEuclideanDistance(lineFrom, point);
            }
            if (u >= 1.0) {
                return CoordUtils.calcEuclideanDistance(lineTo, point);
            }
            return CoordUtils.calcEuclideanDistance(new Coord(lineFrom.getX() + u * lineDX, lineFrom.getY() + u * lineDY), point);
        }
        if (lineFrom.hasZ() && lineTo.hasZ() && point.hasZ()) {
            double lineDX = lineTo.getX() - lineFrom.getX();
            double lineDY = lineTo.getY() - lineFrom.getY();
            double lineDZ = lineTo.getZ() - lineFrom.getZ();
            if (lineDX == 0.0 && lineDY == 0.0 && lineDZ == 0.0) {
                return CoordUtils.calcEuclideanDistance(lineFrom, point);
            }
            Coord v = CoordUtils.minus(lineTo, lineFrom);
            Coord w = CoordUtils.minus(point, lineFrom);
            double c1 = CoordUtils.dotProduct(w, v);
            if (c1 <= 0.0) {
                Coord m3 = CoordUtils.minus(point, lineFrom);
                return Math.sqrt(CoordUtils.dotProduct(m3, m3));
            }
            double c2 = CoordUtils.dotProduct(v, v);
            if (c2 <= c1) {
                Coord m4 = CoordUtils.minus(point, lineTo);
                return Math.sqrt(CoordUtils.dotProduct(m4, m4));
            }
            double b = c1 / c2;
            Coord p = CoordUtils.plus(lineFrom, CoordUtils.scalarMult(b, v));
            Coord m5 = CoordUtils.minus(point, p);
            return Math.sqrt(CoordUtils.dotProduct(m5, m5));
        }
        if (!onlyOnceWarnGiven) {
            Logger.getLogger(CoordUtils.class).warn("Mix of 2D / 3D coordinates. Assuming 2D only.\n This message given only once.");
            onlyOnceWarnGiven = true;
        }
        return CoordUtils.distancePointLinesegment(new Coord(lineFrom.getX(), lineFrom.getY()), new Coord(lineTo.getX(), lineTo.getY()), new Coord(point.getX(), point.getY()));
    }

    public static Coord orthogonalProjectionOnLineSegment(Coord lineFrom, Coord lineTo, Coord point) {
        if (!(lineFrom.hasZ() || lineTo.hasZ() || point.hasZ())) {
            double lineDX = lineTo.getX() - lineFrom.getX();
            double lineDY = lineTo.getY() - lineFrom.getY();
            if (lineDX == 0.0 && lineDY == 0.0) {
                return lineFrom;
            }
            double u = ((point.getX() - lineFrom.getX()) * lineDX + (point.getY() - lineFrom.getY()) * lineDY) / (lineDX * lineDX + lineDY * lineDY);
            if (u <= 0.0) {
                return lineFrom;
            }
            if (u >= 1.0) {
                return lineTo;
            }
            return new Coord(lineFrom.getX() + u * lineDX, lineFrom.getY() + u * lineDY);
        }
        if (lineFrom.hasZ() && lineTo.hasZ() && point.hasZ()) {
            Coord direction = CoordUtils.minus(lineTo, lineFrom);
            double t0 = CoordUtils.dotProduct(direction, CoordUtils.minus(point, lineFrom)) / CoordUtils.dotProduct(direction, direction);
            Coord q = CoordUtils.plus(lineFrom, CoordUtils.scalarMult(t0, direction));
            return q;
        }
        if (!onlyOnceWarnGiven) {
            Logger.getLogger(CoordUtils.class).warn("Mix of 2D / 3D coordinates. Assuming 2D only.\n This message given only once.");
            onlyOnceWarnGiven = true;
        }
        return CoordUtils.orthogonalProjectionOnLineSegment(new Coord(lineFrom.getX(), lineFrom.getY()), new Coord(lineTo.getX(), lineTo.getY()), new Coord(point.getX(), point.getY()));
    }
}

