/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.geotools.geometry.jts.GeometryBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.opengis.feature.simple.SimpleFeature;

public class GeometryUtils {
    private GeometryUtils() {
    }

    public static List<Link> findIntersectingLinks(Link link, Network network) {
        LineString segment = GeometryUtils.createGeotoolsLineString(link);
        return GeometryUtils.findIntersectingLinks(segment, network);
    }

    public static List<Link> findIntersectingLinks(LineString lineString, Network network) {
        LinkedHashMap<Link, LineString> segments = new LinkedHashMap<Link, LineString>();
        for (Link link : network.getLinks().values()) {
            LineString theSegment = GeometryUtils.createGeotoolsLineString(link);
            segments.put(link, theSegment);
        }
        ArrayList<Link> resultList = new ArrayList<Link>();
        for (Map.Entry entry : segments.entrySet()) {
            if (!lineString.intersects((Geometry)entry.getValue())) continue;
            resultList.add((Link)entry.getKey());
        }
        return resultList;
    }

    public static LineString createGeotoolsLineString(Link link) {
        Coordinate fromCoord = MGC.coord2Coordinate(link.getFromNode().getCoord());
        Coordinate toCoord = MGC.coord2Coordinate(link.getToNode().getCoord());
        LineString theSegment = new GeometryFactory().createLineString(new Coordinate[]{fromCoord, toCoord});
        return theSegment;
    }

    public static Point createGeotoolsPoint(Coord coord) {
        Coordinate coordinate = MGC.coord2Coordinate(coord);
        Point point = new GeometryFactory().createPoint(coordinate);
        return point;
    }

    public static Polygon createGeotoolsPolygon(List<Coord> coords) {
        double[] flatArray = new double[coords.size() * 2];
        int ii = 0;
        for (Coord coord : coords) {
            flatArray[ii] = coord.getX();
            flatArray[++ii] = coord.getY();
            ++ii;
        }
        return new GeometryBuilder().polygon(flatArray);
    }

    public static Point getRandomPointInFeature(Random rnd, SimpleFeature ft) {
        Gbl.assertNotNull(ft);
        Point p = null;
        do {
            double x = ft.getBounds().getMinX() + rnd.nextDouble() * (ft.getBounds().getMaxX() - ft.getBounds().getMinX());
            double y = ft.getBounds().getMinY() + rnd.nextDouble() * (ft.getBounds().getMaxY() - ft.getBounds().getMinY());
            p = MGC.xy2Point(x, y);
        } while (!((Geometry)ft.getDefaultGeometry()).contains(p));
        return p;
    }
}

