/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry.transformations;

import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordinateTransformation;

public class CH1903LV03toWGS84
implements CoordinateTransformation {
    @Override
    public Coord transform(Coord coord) {
        double yNorm = (coord.getX() - 600000.0) / 1000000.0;
        double xNorm = (coord.getY() - 200000.0) / 1000000.0;
        double longitude10000Sec = 2.6779094 + 4.728982 * yNorm + 0.791484 * yNorm * xNorm + 0.1306 * yNorm * Math.pow(xNorm, 2.0) - 0.0436 * Math.pow(yNorm, 3.0);
        double latitude10000Sec = 16.9023892 + 3.238272 * xNorm - 0.270978 * Math.pow(yNorm, 2.0) - 0.002528 * Math.pow(xNorm, 2.0) - 0.0447 * Math.pow(yNorm, 2.0) * xNorm - 0.014 * Math.pow(xNorm, 3.0);
        try {
            double elevation = coord.getZ();
            return new Coord(longitude10000Sec * 100.0 / 36.0, latitude10000Sec * 100.0 / 36.0, elevation);
        }
        catch (Exception e) {
            return new Coord(longitude10000Sec * 100.0 / 36.0, latitude10000Sec * 100.0 / 36.0);
        }
    }
}

