/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry.transformations;

import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordinateTransformation;

public class GK4toWGS84
implements CoordinateTransformation {
    private static final double a = 6377397.155;
    private static final double e = 0.081696831;
    private static final double falseEasting = 4500110.0;
    private static final double falseNorthing = 116.0;
    private static final double k0 = 1.0;
    private static final double projectionLongitude = 0.20943951023931953;
    private static final double e2 = 0.00667437219544256;
    private static final double e_2 = 0.0067192187623249175;
    private static final double e1 = (1.0 - Math.pow(0.9933256278045575, 0.5)) / (1.0 + Math.pow(0.9933256278045575, 0.5));
    private static final double M0 = 0.0;
    private static final double MU1_DIVISOR = 6366774.740152045;
    private static final double[] PHI1_DIVIDENS = new double[]{3.0 * e1 / 2.0 - 27.0 * Math.pow(e1, 3.0) / 32.0, 21.0 * Math.pow(e1, 2.0) / 16.0 - 55.0 * Math.pow(e1, 4.0) / 32.0, 151.0 * Math.pow(e1, 3.0) / 96.0, 1097.0 * Math.pow(e1, 4.0) / 512.0};

    @Override
    public Coord transform(Coord coord) {
        double easting = coord.getX();
        double northing = coord.getY();
        double M1 = 0.0 + (northing - 116.0) / 1.0;
        double mu1 = M1 / 6366774.740152045;
        double phi1 = mu1 + PHI1_DIVIDENS[0] * Math.sin(2.0 * mu1) + PHI1_DIVIDENS[1] * Math.sin(4.0 * mu1) + PHI1_DIVIDENS[2] * Math.sin(6.0 * mu1) + PHI1_DIVIDENS[3] * Math.sin(8.0 * mu1);
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double tanphi1 = Math.tan(phi1);
        double C1 = 0.0067192187623249175 * cosphi1 * cosphi1;
        double T1 = Math.pow(tanphi1, 2.0);
        double rho1 = 6334832.032749374 / Math.pow(1.0 - 0.00667437219544256 * sinphi1 * sinphi1, 1.5);
        double nu1 = 6377397.155 / Math.pow(1.0 - 0.00667437219544256 * sinphi1 * sinphi1, 0.5);
        double D = (easting - 4500110.0) / (nu1 * 1.0);
        double latitude = phi1 - nu1 * tanphi1 / rho1 * (Math.pow(D, 2.0) / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 0.06047296886092426) * Math.pow(D, 4.0) / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 1.6932431281058793 - 3.0 * C1 * C1) * Math.pow(D, 6.0) / 720.0);
        double longitude = 0.20943951023931953 + (D - (1.0 + 2.0 * T1 + C1) * Math.pow(D, 3.0) / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 0.05375375009859934 + 24.0 * T1 * T1) * Math.pow(D, 5.0) / 120.0) / cosphi1;
        latitude = latitude * 180.0 / Math.PI;
        longitude = longitude * 180.0 / Math.PI;
        try {
            double elevation = coord.getZ();
            return new Coord(longitude, latitude, elevation);
        }
        catch (Exception e) {
            return new Coord(longitude, latitude);
        }
    }
}

