/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry.transformations;

import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Point;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.geotools.MGC;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeotoolsTransformation
implements CoordinateTransformation {
    private MathTransform transform;

    public GeotoolsTransformation(String from, String to) {
        CoordinateReferenceSystem sourceCRS = MGC.getCRS(from);
        CoordinateReferenceSystem targetCRS = MGC.getCRS(to);
        try {
            this.transform = CRS.findMathTransform(sourceCRS, targetCRS, true);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Coord transform(Coord coord) {
        Point p = null;
        try {
            p = (Point)JTS.transform(MGC.coord2Point(coord), this.transform);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        if (coord.hasZ()) {
            return CoordUtils.createCoord(p.getX(), p.getY(), coord.getZ());
        }
        return MGC.point2Coord(p);
    }
}

